/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.android.dex.io;

import com.tencent.tinker.android.dex.Annotation;
import com.tencent.tinker.android.dex.AnnotationSet;
import com.tencent.tinker.android.dex.AnnotationSetRefList;
import com.tencent.tinker.android.dex.AnnotationsDirectory;
import com.tencent.tinker.android.dex.ClassData;
import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Code;
import com.tencent.tinker.android.dex.DebugInfoItem;
import com.tencent.tinker.android.dex.DexException;
import com.tencent.tinker.android.dex.EncodedValue;
import com.tencent.tinker.android.dex.EncodedValueReader;
import com.tencent.tinker.android.dex.FieldId;
import com.tencent.tinker.android.dex.Leb128;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.Mutf8;
import com.tencent.tinker.android.dex.ProtoId;
import com.tencent.tinker.android.dex.SizeOf;
import com.tencent.tinker.android.dex.StringData;
import com.tencent.tinker.android.dex.TypeList;
import com.tencent.tinker.android.dex.util.ByteInput;
import com.tencent.tinker.android.dex.util.ByteOutput;
import java.io.ByteArrayOutputStream;
import java.io.UTFDataFormatException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DexDataBuffer
implements ByteInput,
ByteOutput {
    public static final int DEFAULT_BUFFER_SIZE = 512;
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    private ByteBuffer data;
    private int dataBound;
    private boolean isResizeAllowed;

    public DexDataBuffer() {
        this.data = ByteBuffer.allocate(512);
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.dataBound = this.data.position();
        this.data.limit(this.data.capacity());
        this.isResizeAllowed = true;
    }

    public DexDataBuffer(ByteBuffer data) {
        this.data = data;
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.dataBound = data.limit();
        this.isResizeAllowed = false;
    }

    public DexDataBuffer(ByteBuffer data, boolean isResizeAllowed) {
        this.data = data;
        this.data.order(ByteOrder.LITTLE_ENDIAN);
        this.dataBound = data.limit();
        this.isResizeAllowed = isResizeAllowed;
    }

    public int position() {
        return this.data.position();
    }

    public void position(int pos) {
        this.data.position(pos);
    }

    public int available() {
        return this.dataBound - this.data.position();
    }

    private void ensureBufferSize(int bytes) {
        if (this.data.position() + bytes > this.data.limit() && this.isResizeAllowed) {
            byte[] array = this.data.array();
            byte[] newArray = new byte[array.length + bytes + (array.length >> 1)];
            System.arraycopy(array, 0, newArray, 0, this.data.position());
            int lastPos = this.data.position();
            this.data = ByteBuffer.wrap(newArray);
            this.data.order(ByteOrder.LITTLE_ENDIAN);
            this.data.position(lastPos);
            this.data.limit(this.data.capacity());
        }
    }

    public byte[] array() {
        byte[] result = new byte[this.dataBound];
        byte[] dataArray = this.data.array();
        System.arraycopy(dataArray, 0, result, 0, this.dataBound);
        return result;
    }

    @Override
    public byte readByte() {
        return this.data.get();
    }

    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    public short readShort() {
        return this.data.getShort();
    }

    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    public int readInt() {
        return this.data.getInt();
    }

    public byte[] readByteArray(int length) {
        byte[] result = new byte[length];
        this.data.get(result);
        return result;
    }

    public short[] readShortArray(int length) {
        if (length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[length];
        for (int i = 0; i < length; ++i) {
            result[i] = this.readShort();
        }
        return result;
    }

    public int readUleb128() {
        return Leb128.readUnsignedLeb128(this);
    }

    public int readUleb128p1() {
        return Leb128.readUnsignedLeb128(this) - 1;
    }

    public int readSleb128() {
        return Leb128.readSignedLeb128(this);
    }

    public StringData readStringData() {
        int off = this.data.position();
        try {
            int expectedLength = this.readUleb128();
            String result = Mutf8.decode(this, new char[expectedLength]);
            if (result.length() != expectedLength) {
                throw new DexException("Declared length " + expectedLength + " doesn't match decoded length of " + result.length());
            }
            return new StringData(off, result);
        }
        catch (UTFDataFormatException e) {
            throw new DexException(e);
        }
    }

    public TypeList readTypeList() {
        int off = this.data.position();
        int size = this.readInt();
        short[] types = this.readShortArray(size);
        return new TypeList(off, types);
    }

    public FieldId readFieldId() {
        int off = this.data.position();
        int declaringClassIndex = this.readUnsignedShort();
        int typeIndex = this.readUnsignedShort();
        int nameIndex = this.readInt();
        return new FieldId(off, declaringClassIndex, typeIndex, nameIndex);
    }

    public MethodId readMethodId() {
        int off = this.data.position();
        int declaringClassIndex = this.readUnsignedShort();
        int protoIndex = this.readUnsignedShort();
        int nameIndex = this.readInt();
        return new MethodId(off, declaringClassIndex, protoIndex, nameIndex);
    }

    public ProtoId readProtoId() {
        int off = this.data.position();
        int shortyIndex = this.readInt();
        int returnTypeIndex = this.readInt();
        int parametersOffset = this.readInt();
        return new ProtoId(off, shortyIndex, returnTypeIndex, parametersOffset);
    }

    public ClassDef readClassDef() {
        int off = this.position();
        int type = this.readInt();
        int accessFlags = this.readInt();
        int supertype = this.readInt();
        int interfacesOffset = this.readInt();
        int sourceFileIndex = this.readInt();
        int annotationsOffset = this.readInt();
        int classDataOffset = this.readInt();
        int staticValuesOffset = this.readInt();
        return new ClassDef(off, type, accessFlags, supertype, interfacesOffset, sourceFileIndex, annotationsOffset, classDataOffset, staticValuesOffset);
    }

    public Code readCode() {
        Code.Try[] tries;
        Code.CatchHandler[] catchHandlers;
        int off = this.data.position();
        int registersSize = this.readUnsignedShort();
        int insSize = this.readUnsignedShort();
        int outsSize = this.readUnsignedShort();
        int triesSize = this.readUnsignedShort();
        int debugInfoOffset = this.readInt();
        int instructionsSize = this.readInt();
        short[] instructions = this.readShortArray(instructionsSize);
        if (triesSize > 0) {
            if (instructions.length % 2 == 1) {
                this.readShort();
            }
            int posBeforeTries = this.data.position();
            this.skip(triesSize * 8);
            catchHandlers = this.readCatchHandlers();
            int posAfterCatchHandlers = this.data.position();
            this.data.position(posBeforeTries);
            tries = this.readTries(triesSize, catchHandlers);
            this.data.position(posAfterCatchHandlers);
        } else {
            tries = new Code.Try[]{};
            catchHandlers = new Code.CatchHandler[]{};
        }
        return new Code(off, registersSize, insSize, outsSize, debugInfoOffset, instructions, tries, catchHandlers);
    }

    private Code.CatchHandler[] readCatchHandlers() {
        int baseOffset = this.data.position();
        int catchHandlersSize = this.readUleb128();
        Code.CatchHandler[] result = new Code.CatchHandler[catchHandlersSize];
        for (int i = 0; i < catchHandlersSize; ++i) {
            int offset = this.data.position() - baseOffset;
            result[i] = this.readCatchHandler(offset);
        }
        return result;
    }

    private Code.Try[] readTries(int triesSize, Code.CatchHandler[] catchHandlers) {
        Code.Try[] result = new Code.Try[triesSize];
        for (int i = 0; i < triesSize; ++i) {
            int startAddress = this.readInt();
            int instructionCount = this.readUnsignedShort();
            int handlerOffset = this.readUnsignedShort();
            int catchHandlerIndex = this.findCatchHandlerIndex(catchHandlers, handlerOffset);
            result[i] = new Code.Try(startAddress, instructionCount, catchHandlerIndex);
        }
        return result;
    }

    private int findCatchHandlerIndex(Code.CatchHandler[] catchHandlers, int offset) {
        for (int i = 0; i < catchHandlers.length; ++i) {
            Code.CatchHandler catchHandler = catchHandlers[i];
            if (catchHandler.offset != offset) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    private Code.CatchHandler readCatchHandler(int offset) {
        int size = this.readSleb128();
        int handlersCount = Math.abs(size);
        int[] typeIndexes = new int[handlersCount];
        int[] addresses = new int[handlersCount];
        for (int i = 0; i < handlersCount; ++i) {
            typeIndexes[i] = this.readUleb128();
            addresses[i] = this.readUleb128();
        }
        int catchAllAddress = size <= 0 ? this.readUleb128() : -1;
        return new Code.CatchHandler(typeIndexes, addresses, catchAllAddress, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DebugInfoItem readDebugInfoItem() {
        int off = this.data.position();
        int lineStart = this.readUleb128();
        int parametersSize = this.readUleb128();
        int[] parameterNames = new int[parametersSize];
        for (int i = 0; i < parametersSize; ++i) {
            parameterNames[i] = this.readUleb128p1();
        }
        ByteArrayOutputStream baos = null;
        try {
            final ByteArrayOutputStream baosRef = baos = new ByteArrayOutputStream(64);
            ByteOutput outAdapter = new ByteOutput(){

                @Override
                public void writeByte(int i) {
                    baosRef.write(i);
                }
            };
            block16: while (true) {
                byte opcode = this.readByte();
                baos.write(opcode);
                switch (opcode) {
                    case 0: {
                        break block16;
                    }
                    case 1: {
                        int addrDiff = this.readUleb128();
                        Leb128.writeUnsignedLeb128(outAdapter, addrDiff);
                        break;
                    }
                    case 2: {
                        int lineDiff = this.readSleb128();
                        Leb128.writeSignedLeb128(outAdapter, lineDiff);
                        break;
                    }
                    case 3: 
                    case 4: {
                        int registerNum = this.readUleb128();
                        Leb128.writeUnsignedLeb128(outAdapter, registerNum);
                        int nameIndex = this.readUleb128p1();
                        Leb128.writeUnsignedLeb128p1(outAdapter, nameIndex);
                        int typeIndex = this.readUleb128p1();
                        Leb128.writeUnsignedLeb128p1(outAdapter, typeIndex);
                        if (opcode != 4) break;
                        int sigIndex = this.readUleb128p1();
                        Leb128.writeUnsignedLeb128p1(outAdapter, sigIndex);
                        break;
                    }
                    case 5: 
                    case 6: {
                        int registerNum = this.readUleb128();
                        Leb128.writeUnsignedLeb128(outAdapter, registerNum);
                        break;
                    }
                    case 9: {
                        int nameIndex = this.readUleb128p1();
                        Leb128.writeUnsignedLeb128p1(outAdapter, nameIndex);
                    }
                }
            }
            byte[] infoSTM = baos.toByteArray();
            DebugInfoItem debugInfoItem = new DebugInfoItem(off, lineStart, parameterNames, infoSTM);
            return debugInfoItem;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public ClassData readClassData() {
        int off = this.data.position();
        int staticFieldsSize = this.readUleb128();
        int instanceFieldsSize = this.readUleb128();
        int directMethodsSize = this.readUleb128();
        int virtualMethodsSize = this.readUleb128();
        ClassData.Field[] staticFields = this.readFields(staticFieldsSize);
        ClassData.Field[] instanceFields = this.readFields(instanceFieldsSize);
        ClassData.Method[] directMethods = this.readMethods(directMethodsSize);
        ClassData.Method[] virtualMethods = this.readMethods(virtualMethodsSize);
        return new ClassData(off, staticFields, instanceFields, directMethods, virtualMethods);
    }

    private ClassData.Field[] readFields(int count) {
        ClassData.Field[] result = new ClassData.Field[count];
        int fieldIndex = 0;
        for (int i = 0; i < count; ++i) {
            int accessFlags = this.readUleb128();
            result[i] = new ClassData.Field(fieldIndex += this.readUleb128(), accessFlags);
        }
        return result;
    }

    private ClassData.Method[] readMethods(int count) {
        ClassData.Method[] result = new ClassData.Method[count];
        int methodIndex = 0;
        for (int i = 0; i < count; ++i) {
            int accessFlags = this.readUleb128();
            int codeOff = this.readUleb128();
            result[i] = new ClassData.Method(methodIndex += this.readUleb128(), accessFlags, codeOff);
        }
        return result;
    }

    private byte[] getBytesFrom(int start) {
        int end = this.data.position();
        byte[] result = new byte[end - start];
        this.data.position(start);
        this.data.get(result);
        return result;
    }

    public Annotation readAnnotation() {
        int off = this.data.position();
        byte visibility = this.readByte();
        int start = this.data.position();
        new EncodedValueReader(this, 29).skipValue();
        return new Annotation(off, visibility, new EncodedValue(start, this.getBytesFrom(start)));
    }

    public AnnotationSet readAnnotationSet() {
        int off = this.data.position();
        int size = this.readInt();
        int[] annotationOffsets = new int[size];
        for (int i = 0; i < size; ++i) {
            annotationOffsets[i] = this.readInt();
        }
        return new AnnotationSet(off, annotationOffsets);
    }

    public AnnotationSetRefList readAnnotationSetRefList() {
        int off = this.data.position();
        int size = this.readInt();
        int[] annotationSetRefItems = new int[size];
        for (int i = 0; i < size; ++i) {
            annotationSetRefItems[i] = this.readInt();
        }
        return new AnnotationSetRefList(off, annotationSetRefItems);
    }

    public AnnotationsDirectory readAnnotationsDirectory() {
        int off = this.data.position();
        int classAnnotationsOffset = this.readInt();
        int fieldsSize = this.readInt();
        int methodsSize = this.readInt();
        int parameterListSize = this.readInt();
        int[][] fieldAnnotations = new int[fieldsSize][2];
        for (int i = 0; i < fieldsSize; ++i) {
            fieldAnnotations[i][0] = this.readInt();
            fieldAnnotations[i][1] = this.readInt();
        }
        int[][] methodAnnotations = new int[methodsSize][2];
        for (int i = 0; i < methodsSize; ++i) {
            methodAnnotations[i][0] = this.readInt();
            methodAnnotations[i][1] = this.readInt();
        }
        int[][] parameterAnnotations = new int[parameterListSize][2];
        for (int i = 0; i < parameterListSize; ++i) {
            parameterAnnotations[i][0] = this.readInt();
            parameterAnnotations[i][1] = this.readInt();
        }
        return new AnnotationsDirectory(off, classAnnotationsOffset, fieldAnnotations, methodAnnotations, parameterAnnotations);
    }

    public EncodedValue readEncodedArray() {
        int start = this.data.position();
        new EncodedValueReader(this, 28).skipValue();
        return new EncodedValue(start, this.getBytesFrom(start));
    }

    public void skip(int count) {
        if (count < 0) {
            throw new IllegalArgumentException();
        }
        this.data.position(this.data.position() + count);
    }

    public void skipWithAutoExpand(int count) {
        this.ensureBufferSize(1 * count);
        this.skip(count);
    }

    public void alignToFourBytes() {
        this.data.position(this.data.position() + 3 & 0xFFFFFFFC);
    }

    public void alignToFourBytesWithZeroFill() {
        int alignedPos = SizeOf.roundToTimesOfFour(this.data.position());
        this.ensureBufferSize((alignedPos - this.data.position()) * 1);
        while ((this.data.position() & 3) != 0) {
            this.data.put((byte)0);
        }
        if (this.data.position() > this.dataBound) {
            this.dataBound = this.data.position();
        }
    }

    @Override
    public void writeByte(int b) {
        this.ensureBufferSize(1);
        this.data.put((byte)b);
        if (this.data.position() > this.dataBound) {
            this.dataBound = this.data.position();
        }
    }

    public void writeShort(short i) {
        this.ensureBufferSize(2);
        this.data.putShort(i);
        if (this.data.position() > this.dataBound) {
            this.dataBound = this.data.position();
        }
    }

    public void writeUnsignedShort(int i) {
        short s = (short)i;
        if (i != (s & 0xFFFF)) {
            throw new IllegalArgumentException("Expected an unsigned short: " + i);
        }
        this.writeShort(s);
    }

    public void writeInt(int i) {
        this.ensureBufferSize(4);
        this.data.putInt(i);
        if (this.data.position() > this.dataBound) {
            this.dataBound = this.data.position();
        }
    }

    public void write(byte[] bytes) {
        this.ensureBufferSize(bytes.length * 1);
        this.data.put(bytes);
        if (this.data.position() > this.dataBound) {
            this.dataBound = this.data.position();
        }
    }

    public void write(short[] shorts) {
        this.ensureBufferSize(shorts.length * 2);
        for (short s : shorts) {
            this.writeShort(s);
        }
        if (this.data.position() > this.dataBound) {
            this.dataBound = this.data.position();
        }
    }

    public void writeUleb128(int i) {
        Leb128.writeUnsignedLeb128(this, i);
    }

    public void writeUleb128p1(int i) {
        this.writeUleb128(i + 1);
    }

    public void writeSleb128(int i) {
        Leb128.writeSignedLeb128(this, i);
    }

    public int writeStringData(StringData stringData) {
        int off = this.data.position();
        try {
            int length = stringData.value.length();
            this.writeUleb128(length);
            this.write(Mutf8.encode(stringData.value));
            this.writeByte(0);
            return off;
        }
        catch (UTFDataFormatException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int writeTypeList(TypeList typeList) {
        int off = this.data.position();
        short[] types = typeList.types;
        this.writeInt(types.length);
        for (short type : types) {
            this.writeShort(type);
        }
        return off;
    }

    public int writeFieldId(FieldId fieldId) {
        int off = this.data.position();
        this.writeUnsignedShort(fieldId.declaringClassIndex);
        this.writeUnsignedShort(fieldId.typeIndex);
        this.writeInt(fieldId.nameIndex);
        return off;
    }

    public int writeMethodId(MethodId methodId) {
        int off = this.data.position();
        this.writeUnsignedShort(methodId.declaringClassIndex);
        this.writeUnsignedShort(methodId.protoIndex);
        this.writeInt(methodId.nameIndex);
        return off;
    }

    public int writeProtoId(ProtoId protoId) {
        int off = this.data.position();
        this.writeInt(protoId.shortyIndex);
        this.writeInt(protoId.returnTypeIndex);
        this.writeInt(protoId.parametersOffset);
        return off;
    }

    public int writeClassDef(ClassDef classDef) {
        int off = this.data.position();
        this.writeInt(classDef.typeIndex);
        this.writeInt(classDef.accessFlags);
        this.writeInt(classDef.supertypeIndex);
        this.writeInt(classDef.interfacesOffset);
        this.writeInt(classDef.sourceFileIndex);
        this.writeInt(classDef.annotationsOffset);
        this.writeInt(classDef.classDataOffset);
        this.writeInt(classDef.staticValuesOffset);
        return off;
    }

    public int writeCode(Code code) {
        int off = this.data.position();
        this.writeUnsignedShort(code.registersSize);
        this.writeUnsignedShort(code.insSize);
        this.writeUnsignedShort(code.outsSize);
        this.writeUnsignedShort(code.tries.length);
        this.writeInt(code.debugInfoOffset);
        this.writeInt(code.instructions.length);
        this.write(code.instructions);
        if (code.tries.length > 0) {
            if ((code.instructions.length & 1) == 1) {
                this.writeShort((short)0);
            }
            int posBeforeTries = this.data.position();
            this.skipWithAutoExpand(code.tries.length * 8);
            int[] offsets = this.writeCatchHandlers(code.catchHandlers);
            int posAfterCatchHandlers = this.data.position();
            this.data.position(posBeforeTries);
            this.writeTries(code.tries, offsets);
            this.data.position(posAfterCatchHandlers);
        }
        return off;
    }

    private int[] writeCatchHandlers(Code.CatchHandler[] catchHandlers) {
        int baseOffset = this.data.position();
        this.writeUleb128(catchHandlers.length);
        int[] offsets = new int[catchHandlers.length];
        for (int i = 0; i < catchHandlers.length; ++i) {
            offsets[i] = this.data.position() - baseOffset;
            this.writeCatchHandler(catchHandlers[i]);
        }
        return offsets;
    }

    private void writeCatchHandler(Code.CatchHandler catchHandler) {
        int catchAllAddress = catchHandler.catchAllAddress;
        int[] typeIndexes = catchHandler.typeIndexes;
        int[] addresses = catchHandler.addresses;
        if (catchAllAddress != -1) {
            this.writeSleb128(-typeIndexes.length);
        } else {
            this.writeSleb128(typeIndexes.length);
        }
        for (int i = 0; i < typeIndexes.length; ++i) {
            this.writeUleb128(typeIndexes[i]);
            this.writeUleb128(addresses[i]);
        }
        if (catchAllAddress != -1) {
            this.writeUleb128(catchAllAddress);
        }
    }

    private void writeTries(Code.Try[] tries, int[] catchHandlerOffsets) {
        for (Code.Try tryItem : tries) {
            this.writeInt(tryItem.startAddress);
            this.writeUnsignedShort(tryItem.instructionCount);
            this.writeUnsignedShort(catchHandlerOffsets[tryItem.catchHandlerIndex]);
        }
    }

    public int writeDebugInfoItem(DebugInfoItem debugInfoItem) {
        int off = this.data.position();
        this.writeUleb128(debugInfoItem.lineStart);
        int parametersSize = debugInfoItem.parameterNames.length;
        this.writeUleb128(parametersSize);
        for (int i = 0; i < parametersSize; ++i) {
            int parameterName = debugInfoItem.parameterNames[i];
            this.writeUleb128p1(parameterName);
        }
        this.write(debugInfoItem.infoSTM);
        return off;
    }

    public int writeClassData(ClassData classData) {
        int off = this.data.position();
        this.writeUleb128(classData.staticFields.length);
        this.writeUleb128(classData.instanceFields.length);
        this.writeUleb128(classData.directMethods.length);
        this.writeUleb128(classData.virtualMethods.length);
        this.writeFields(classData.staticFields);
        this.writeFields(classData.instanceFields);
        this.writeMethods(classData.directMethods);
        this.writeMethods(classData.virtualMethods);
        return off;
    }

    private void writeFields(ClassData.Field[] fields) {
        int lastOutFieldIndex = 0;
        for (ClassData.Field field : fields) {
            this.writeUleb128(field.fieldIndex - lastOutFieldIndex);
            lastOutFieldIndex = field.fieldIndex;
            this.writeUleb128(field.accessFlags);
        }
    }

    private void writeMethods(ClassData.Method[] methods) {
        int lastOutMethodIndex = 0;
        for (ClassData.Method method : methods) {
            this.writeUleb128(method.methodIndex - lastOutMethodIndex);
            lastOutMethodIndex = method.methodIndex;
            this.writeUleb128(method.accessFlags);
            this.writeUleb128(method.codeOffset);
        }
    }

    public int writeAnnotation(Annotation annotation) {
        int off = this.data.position();
        this.writeByte(annotation.visibility);
        this.writeEncodedArray(annotation.encodedAnnotation);
        return off;
    }

    public int writeAnnotationSet(AnnotationSet annotationSet) {
        int off = this.data.position();
        this.writeInt(annotationSet.annotationOffsets.length);
        for (int annotationOffset : annotationSet.annotationOffsets) {
            this.writeInt(annotationOffset);
        }
        return off;
    }

    public int writeAnnotationSetRefList(AnnotationSetRefList annotationSetRefList) {
        int off = this.data.position();
        this.writeInt(annotationSetRefList.annotationSetRefItems.length);
        for (int annotationSetRefItem : annotationSetRefList.annotationSetRefItems) {
            this.writeInt(annotationSetRefItem);
        }
        return off;
    }

    public int writeAnnotationsDirectory(AnnotationsDirectory annotationsDirectory) {
        int off = this.data.position();
        this.writeInt(annotationsDirectory.classAnnotationsOffset);
        this.writeInt(annotationsDirectory.fieldAnnotations.length);
        this.writeInt(annotationsDirectory.methodAnnotations.length);
        this.writeInt(annotationsDirectory.parameterAnnotations.length);
        for (int[] fieldAnnotation : annotationsDirectory.fieldAnnotations) {
            this.writeInt(fieldAnnotation[0]);
            this.writeInt(fieldAnnotation[1]);
        }
        for (int[] methodAnnotation : annotationsDirectory.methodAnnotations) {
            this.writeInt(methodAnnotation[0]);
            this.writeInt(methodAnnotation[1]);
        }
        for (int[] parameterAnnotation : annotationsDirectory.parameterAnnotations) {
            this.writeInt(parameterAnnotation[0]);
            this.writeInt(parameterAnnotation[1]);
        }
        return off;
    }

    public int writeEncodedArray(EncodedValue encodedValue) {
        int off = this.data.position();
        this.write(encodedValue.data);
        return off;
    }
}

