/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.tinker;

import android.content.Context;
import android.content.Intent;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.app.ApplicationLike;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.File;
import java.util.HashMap;

public class TinkerApplicationHelper {
    private static final String TAG = "Tinker.TinkerApplicationHelper";

    public static boolean isTinkerEnableAll(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int n = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledAll(n);
    }

    public static boolean isTinkerEnableForDex(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int n = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledForDex(n);
    }

    public static boolean isTinkerEnableForNativeLib(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int n = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledForNativeLib(n);
    }

    public static boolean isTinkerEnableForResource(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        int n = applicationLike.getTinkerFlags();
        return ShareTinkerInternals.isTinkerEnabledForResource(n);
    }

    public static File getTinkerPatchDirectory(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        return SharePatchFileUtil.getPatchDirectory((Context)applicationLike.getApplication());
    }

    public static boolean isTinkerLoadSuccess(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        if ((applicationLike = applicationLike.getTinkerResultIntent()) == null) {
            return false;
        }
        int n = ShareIntentUtil.getIntentReturnCode((Intent)applicationLike);
        return n == 0;
    }

    public static HashMap<String, String> getLoadDexesAndMd5(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        if ((applicationLike = applicationLike.getTinkerResultIntent()) == null) {
            return null;
        }
        int n = ShareIntentUtil.getIntentReturnCode((Intent)applicationLike);
        if (n == 0) {
            return ShareIntentUtil.getIntentPatchDexPaths((Intent)applicationLike);
        }
        return null;
    }

    public static HashMap<String, String> getLoadLibraryAndMd5(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        if ((applicationLike = applicationLike.getTinkerResultIntent()) == null) {
            return null;
        }
        int n = ShareIntentUtil.getIntentReturnCode((Intent)applicationLike);
        if (n == 0) {
            return ShareIntentUtil.getIntentPatchLibsPaths((Intent)applicationLike);
        }
        return null;
    }

    public static HashMap<String, String> getPackageConfigs(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        if ((applicationLike = applicationLike.getTinkerResultIntent()) == null) {
            return null;
        }
        int n = ShareIntentUtil.getIntentReturnCode((Intent)applicationLike);
        if (n == 0) {
            return ShareIntentUtil.getIntentPackageConfig((Intent)applicationLike);
        }
        return null;
    }

    public static String getCurrentVersion(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        Object object = applicationLike.getTinkerResultIntent();
        if (object == null) {
            return null;
        }
        String string = ShareIntentUtil.getStringExtra(object, "intent_patch_old_version");
        object = ShareIntentUtil.getStringExtra(object, "intent_patch_new_version");
        boolean bl = ShareTinkerInternals.isInMainProcess((Context)applicationLike.getApplication());
        if (string != null && object != null) {
            if (bl) {
                return object;
            }
            return string;
        }
        return null;
    }

    public static void cleanPatch(ApplicationLike applicationLike) {
        if (applicationLike == null || applicationLike.getApplication() == null) {
            throw new TinkerRuntimeException("tinkerApplication is null");
        }
        if (TinkerApplicationHelper.isTinkerLoadSuccess(applicationLike)) {
            TinkerLog.e(TAG, "it is not safety to clean patch when tinker is loaded, you should kill all your process after clean!", new Object[0]);
        }
        SharePatchFileUtil.deleteDir(SharePatchFileUtil.getPatchDirectory((Context)applicationLike.getApplication()));
    }

    public static void loadArmV7aLibrary(ApplicationLike applicationLike, String string) {
        if (string == null || string.isEmpty() || applicationLike == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike) && TinkerApplicationHelper.loadLibraryFromTinker(applicationLike, "lib/armeabi-v7a", string)) {
            return;
        }
        System.loadLibrary(string);
    }

    public static void loadArmLibrary(ApplicationLike applicationLike, String string) {
        if (string == null || string.isEmpty() || applicationLike == null) {
            throw new TinkerRuntimeException("libName or context is null!");
        }
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike) && TinkerApplicationHelper.loadLibraryFromTinker(applicationLike, "lib/armeabi", string)) {
            return;
        }
        System.loadLibrary(string);
    }

    public static boolean loadLibraryFromTinker(ApplicationLike applicationLike, String string, String object) {
        object = ((String)object).startsWith("lib") ? object : "lib" + (String)object;
        object = ((String)object).endsWith(".so") ? object : (String)object + ".so";
        string = string + "/" + (String)object;
        if (TinkerApplicationHelper.isTinkerEnableForNativeLib(applicationLike) && TinkerApplicationHelper.isTinkerLoadSuccess(applicationLike) && (object = TinkerApplicationHelper.getLoadLibraryAndMd5(applicationLike)) != null) {
            Object object2 = TinkerApplicationHelper.getCurrentVersion(applicationLike);
            if (ShareTinkerInternals.isNullOrNil((String)object2)) {
                return false;
            }
            File file = SharePatchFileUtil.getPatchDirectory((Context)applicationLike.getApplication());
            if (file == null) {
                return false;
            }
            object2 = new File(file.getAbsolutePath() + "/" + SharePatchFileUtil.getPatchVersionDirectory((String)object2));
            object2 = ((File)object2).getAbsolutePath() + "/lib";
            for (String string2 : ((HashMap)object).keySet()) {
                String string3;
                File file2;
                if (!string2.equals(string) || !(file2 = new File(string3 = (String)object2 + "/" + string2)).exists()) continue;
                boolean bl = applicationLike.getTinkerLoadVerifyFlag();
                if (bl && !SharePatchFileUtil.verifyFileMd5(file2, (String)((HashMap)object).get(string2))) {
                    TinkerLog.i(TAG, "loadLibraryFromTinker md5mismatch fail:" + string3, new Object[0]);
                    continue;
                }
                System.load(string3);
                TinkerLog.i(TAG, "loadLibraryFromTinker success:" + string3, new Object[0]);
                return true;
            }
        }
        return false;
    }
}

