/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.lib.patch;

import android.content.Context;
import android.os.SystemClock;
import com.tencent.tinker.commons.dexpatcher.DexPatchApplier;
import com.tencent.tinker.lib.patch.BasePatchInternal;
import com.tencent.tinker.lib.tinker.Tinker;
import com.tencent.tinker.lib.util.TinkerLog;
import com.tencent.tinker.loader.TinkerParallelDexOptimizer;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.DexFile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class DexDiffPatchInternal
extends BasePatchInternal {
    protected static final String TAG = "Tinker.DexDiffPatchInternal";

    protected static boolean tryRecoverDexFiles(Tinker object, ShareSecurityCheck shareSecurityCheck, Context context, String string, File file) {
        if (!((Tinker)object).isEnabledForDex()) {
            TinkerLog.w(TAG, "patch recover, dex is not enabled", new Object[0]);
            return true;
        }
        object = shareSecurityCheck.getMetaContentMap().get("assets/dex_meta.txt");
        if (object == null) {
            TinkerLog.w(TAG, "patch recover, dex is not contained", new Object[0]);
            return true;
        }
        long l = SystemClock.elapsedRealtime();
        boolean bl = DexDiffPatchInternal.patchDexExtractViaDexDiff(context, string, (String)object, file);
        long l2 = SystemClock.elapsedRealtime() - l;
        TinkerLog.i(TAG, "recover dex result:%b, cost:%d", bl, l2);
        return bl;
    }

    private static boolean patchDexExtractViaDexDiff(Context object, String string, String fileArray, File file) {
        Object object2 = string + "/dex" + "/";
        if (!DexDiffPatchInternal.extractDexDiffInternals((Context)object, (String)object2, (String)fileArray, file, 3)) {
            TinkerLog.w(TAG, "patch recover, extractDiffInternals fail", new Object[0]);
            return false;
        }
        object = Tinker.with((Context)object);
        fileArray = new File((String)object2);
        if ((fileArray = fileArray.listFiles()) != null) {
            object2 = new File(string = string + "/odex" + "/");
            if (!((File)object2).exists() && !((File)object2).mkdirs()) {
                TinkerLog.w(TAG, "patch recover, make optimizeDexDirectoryFile fail", new Object[0]);
                return false;
            }
            TinkerLog.w(TAG, "patch recover, try to optimize dex file count:%d", fileArray.length);
            boolean bl = TinkerParallelDexOptimizer.optimizeAll(fileArray, (File)object2, new TinkerParallelDexOptimizer.ResultCallback((Tinker)object, file, string){
                long startTime;
                final /* synthetic */ Tinker val$manager;
                final /* synthetic */ File val$patchFile;
                final /* synthetic */ String val$optimizeDexDirectory;
                {
                    this.val$manager = tinker;
                    this.val$patchFile = file;
                    this.val$optimizeDexDirectory = string;
                }

                @Override
                public final void onStart(File file, File file2) {
                    this.startTime = System.currentTimeMillis();
                    TinkerLog.i(DexDiffPatchInternal.TAG, "start to optimize dex %s", file.getPath());
                }

                @Override
                public final void onSuccess(File file, File file2) {
                    TinkerLog.i(DexDiffPatchInternal.TAG, "success to optimize dex %s use time %d", file.getPath(), System.currentTimeMillis() - this.startTime);
                }

                @Override
                public final void onFailed(File file, File file2, Throwable throwable) {
                    TinkerLog.i(DexDiffPatchInternal.TAG, "fail to optimize dex %s use time %d", file.getPath(), System.currentTimeMillis() - this.startTime);
                    SharePatchFileUtil.safeDeleteFile(file);
                    this.val$manager.getPatchReporter().onPatchDexOptFail(this.val$patchFile, file, this.val$optimizeDexDirectory, file.getName(), throwable);
                }
            });
            if (bl) {
                for (File file2 : fileArray) {
                    try {
                        if (!SharePatchFileUtil.isLegalFile(file2)) {
                            TinkerLog.e(TAG, "single dex optimizer file %s is not exist, just return false", file2);
                            return false;
                        }
                        String string2 = SharePatchFileUtil.optimizedPathFor(file2, (File)object2);
                        File file3 = new File(string2);
                        if (SharePatchFileUtil.isLegalFile(file3)) continue;
                        TinkerLog.e(TAG, "parallel dex optimizer file %s fail, optimize again", string2);
                        long l = System.currentTimeMillis();
                        DexFile.loadDex((String)file2.getAbsolutePath(), (String)string2, (int)0);
                        TinkerLog.i(TAG, "success single dex optimize file, path: %s, use time: %d", file2.getPath(), System.currentTimeMillis() - l);
                        if (SharePatchFileUtil.isLegalFile(file3)) continue;
                        ((Tinker)object).getPatchReporter().onPatchDexOptFail(file, file2, string, file2.getName(), new TinkerRuntimeException("dexOpt file:" + string2 + " is not exist"));
                        return false;
                    }
                    catch (Throwable throwable) {
                        TinkerLog.e(TAG, "dex optimize or load failed, path:" + file2.getPath(), new Object[0]);
                        SharePatchFileUtil.safeDeleteFile(file2);
                        ((Tinker)object).getPatchReporter().onPatchDexOptFail(file, file2, string, file2.getName(), throwable);
                        return false;
                    }
                }
            }
            return bl;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean extractDexDiffInternals(Context var0, String var1_3, String var2_4, File var3_5, int var4_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 16[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean extractDexToJar(ZipFile zipFile, ZipEntry zipEntry, File file, String string) {
        int n = 0;
        boolean bl = false;
        while (n < 2 && !bl) {
            ++n;
            Object object = new FileOutputStream(file);
            Object object2 = zipFile.getInputStream(zipEntry);
            ZipOutputStream zipOutputStream = null;
            BufferedInputStream bufferedInputStream = null;
            TinkerLog.i(TAG, "try Extracting " + file.getPath(), new Object[0]);
            try {
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)object));
                bufferedInputStream = new BufferedInputStream((InputStream)object2);
                object = new byte[16384];
                object2 = new ZipEntry("classes.dex");
                zipOutputStream.putNextEntry((ZipEntry)object2);
                int n2 = bufferedInputStream.read((byte[])object);
                while (n2 != -1) {
                    zipOutputStream.write((byte[])object, 0, n2);
                    n2 = bufferedInputStream.read((byte[])object);
                }
                zipOutputStream.closeEntry();
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(bufferedInputStream);
                SharePatchFileUtil.closeQuietly(zipOutputStream);
                throw throwable;
            }
            SharePatchFileUtil.closeQuietly(bufferedInputStream);
            SharePatchFileUtil.closeQuietly(zipOutputStream);
            bl = SharePatchFileUtil.verifyDexFileMd5(file, string);
            TinkerLog.i(TAG, "isExtractionSuccessful: %b", bl);
            if (bl) continue;
            file.delete();
            if (!file.exists()) continue;
            TinkerLog.e(TAG, "Failed to delete corrupted dex " + file.getPath(), new Object[0]);
        }
        return bl;
    }

    private static boolean extractDexFile(ZipFile zipFile, ZipEntry zipEntry, File file, ShareDexDiffPatchInfo shareDexDiffPatchInfo) {
        String string = ShareTinkerInternals.isVmArt() ? shareDexDiffPatchInfo.destMd5InArt : shareDexDiffPatchInfo.destMd5InDvm;
        String string2 = shareDexDiffPatchInfo.rawName;
        boolean bl = shareDexDiffPatchInfo.isJarMode;
        if (SharePatchFileUtil.isRawDexFile(string2) && bl) {
            return DexDiffPatchInternal.extractDexToJar(zipFile, zipEntry, file, string);
        }
        return DexDiffPatchInternal.extract(zipFile, zipEntry, file, string, true);
    }

    private static void patchDexFile(ZipFile zipFile, ZipFile closeable, ZipEntry zipEntry, ZipEntry zipEntry2, ShareDexDiffPatchInfo shareDexDiffPatchInfo, File file) {
        BufferedInputStream bufferedInputStream;
        BufferedInputStream bufferedInputStream2;
        block9: {
            bufferedInputStream2 = null;
            bufferedInputStream = null;
            try {
                block10: {
                    bufferedInputStream2 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                    bufferedInputStream = zipEntry2 != null ? new BufferedInputStream(((ZipFile)closeable).getInputStream(zipEntry2)) : null;
                    boolean bl = SharePatchFileUtil.isRawDexFile(shareDexDiffPatchInfo.rawName);
                    if (bl && !shareDexDiffPatchInfo.isJarMode) break block10;
                    closeable = null;
                    try {
                        block12: {
                            block11: {
                                closeable = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                                ((ZipOutputStream)closeable).putNextEntry(new ZipEntry("classes.dex"));
                                if (bl) break block11;
                                ZipInputStream zipInputStream = null;
                                try {
                                    zipInputStream = new ZipInputStream(bufferedInputStream2);
                                    while ((zipEntry = zipInputStream.getNextEntry()) != null && !"classes.dex".equals(zipEntry.getName())) {
                                    }
                                    if (zipEntry == null) {
                                        throw new TinkerRuntimeException("can't recognize zip dex format file:" + file.getAbsolutePath());
                                    }
                                    new DexPatchApplier((InputStream)zipInputStream, (int)zipEntry.getSize(), (InputStream)bufferedInputStream).executeAndSaveTo((OutputStream)closeable);
                                }
                                catch (Throwable throwable) {
                                    SharePatchFileUtil.closeQuietly(zipInputStream);
                                    throw throwable;
                                }
                                SharePatchFileUtil.closeQuietly(zipInputStream);
                                break block12;
                            }
                            new DexPatchApplier((InputStream)bufferedInputStream2, (int)zipEntry.getSize(), (InputStream)bufferedInputStream).executeAndSaveTo((OutputStream)closeable);
                        }
                        ((ZipOutputStream)closeable).closeEntry();
                        break block9;
                    }
                    finally {
                        SharePatchFileUtil.closeQuietly(closeable);
                    }
                }
                new DexPatchApplier((InputStream)bufferedInputStream2, (int)zipEntry.getSize(), (InputStream)bufferedInputStream).executeAndSaveTo(file);
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(bufferedInputStream2);
                SharePatchFileUtil.closeQuietly(bufferedInputStream);
                throw throwable;
            }
        }
        SharePatchFileUtil.closeQuietly(bufferedInputStream2);
        SharePatchFileUtil.closeQuietly(bufferedInputStream);
    }
}

