/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.struct;

import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dex.util.CompareUtils;
import com.tencent.tinker.android.dex.util.FileUtils;
import com.tencent.tinker.android.dx.util.Hex;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SmallPatchedDexItemFile {
    public static final byte[] MAGIC = new byte[]{68, 68, 69, 88, 84, 82, 65};
    public static final short CURRENT_VERSION = 1;
    private final List<String> oldDexSigns = new ArrayList<String>();
    private final Map<String, DexOffsets> oldDexSignToOffsetInfoMap = new HashMap<String, DexOffsets>();
    private final Map<String, BitSet> oldDexSignToStringIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToTypeIdIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToTypeListIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToProtoIdIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToFieldIdIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToMethodIdIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToAnnotationIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToAnnotationSetIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToAnnotationSetRefListIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToAnnotationsDirectoryIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToEncodedArrayIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToDebugInfoIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToCodeIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToClassDataIndicesInSmallPatch = new HashMap<String, BitSet>();
    private final Map<String, BitSet> oldDexSignToClassDefIndicesInSmallPatch = new HashMap<String, BitSet>();
    private int version;
    private int firstChunkOffset;

    public SmallPatchedDexItemFile(File input) throws IOException {
        DexDataBuffer buffer = new DexDataBuffer(ByteBuffer.wrap(FileUtils.readFile((File)input)));
        this.init(buffer);
    }

    public SmallPatchedDexItemFile(InputStream is) throws IOException {
        DexDataBuffer buffer = new DexDataBuffer(ByteBuffer.wrap(FileUtils.readStream((InputStream)is)));
        this.init(buffer);
    }

    private void init(DexDataBuffer buffer) throws IOException {
        Object oldDexSign;
        int i;
        byte[] magic = buffer.readByteArray(MAGIC.length);
        if (CompareUtils.uArrCompare((byte[])magic, (byte[])MAGIC) != 0) {
            throw new IllegalStateException("bad dexdiff extra file magic: " + Arrays.toString(magic));
        }
        this.version = buffer.readShort();
        if (this.version != 1) {
            throw new IllegalStateException("bad dexdiff extra file version: " + this.version + ", expected: " + 1);
        }
        this.firstChunkOffset = buffer.readInt();
        buffer.position(this.firstChunkOffset);
        int oldDexSignCount = buffer.readUleb128();
        for (i = 0; i < oldDexSignCount; ++i) {
            oldDexSign = buffer.readByteArray(20);
            this.oldDexSigns.add(Hex.toHexString((byte[])oldDexSign));
        }
        for (i = 0; i < oldDexSignCount; ++i) {
            oldDexSign = this.oldDexSigns.get(i);
            DexOffsets dexOffsets = new DexOffsets();
            dexOffsets.stringIdsOffset = buffer.readInt();
            dexOffsets.typeIdsOffset = buffer.readInt();
            dexOffsets.protoIdsOffset = buffer.readInt();
            dexOffsets.fieldIdsOffset = buffer.readInt();
            dexOffsets.methodIdsOffset = buffer.readInt();
            dexOffsets.classDefsOffset = buffer.readInt();
            dexOffsets.stringDataItemsOffset = buffer.readInt();
            dexOffsets.typeListsOffset = buffer.readInt();
            dexOffsets.annotationsOffset = buffer.readInt();
            dexOffsets.annotationSetsOffset = buffer.readInt();
            dexOffsets.annotationSetRefListsOffset = buffer.readInt();
            dexOffsets.annotationsDirectoriesOffset = buffer.readInt();
            dexOffsets.debugInfoItemsOffset = buffer.readInt();
            dexOffsets.codeItemsOffset = buffer.readInt();
            dexOffsets.classDataItemsOffset = buffer.readInt();
            dexOffsets.encodedArraysOffset = buffer.readInt();
            dexOffsets.mapListOffset = buffer.readInt();
            dexOffsets.dexSize = buffer.readInt();
            this.oldDexSignToOffsetInfoMap.put((String)oldDexSign, dexOffsets);
        }
        this.readDataChunk(buffer, this.oldDexSignToStringIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToTypeIdIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToTypeListIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToProtoIdIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToFieldIdIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToMethodIdIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToAnnotationIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToAnnotationSetIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToAnnotationSetRefListIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToAnnotationsDirectoryIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToEncodedArrayIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToDebugInfoIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToCodeIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToClassDataIndicesInSmallPatch);
        this.readDataChunk(buffer, this.oldDexSignToClassDefIndicesInSmallPatch);
    }

    private void readDataChunk(DexDataBuffer buffer, Map<String, BitSet> oldDexSignToIndicesInSmallPatchMap) {
        int oldDexSignCount = this.oldDexSigns.size();
        for (int i = 0; i < oldDexSignCount; ++i) {
            int itemCount = buffer.readUleb128();
            int prevIndex = 0;
            for (int j = 0; j < itemCount; ++j) {
                int indexDelta = buffer.readSleb128();
                prevIndex += indexDelta;
                String oldDexSign = this.oldDexSigns.get(i);
                BitSet indices = oldDexSignToIndicesInSmallPatchMap.get(oldDexSign);
                if (indices == null) {
                    indices = new BitSet();
                    oldDexSignToIndicesInSmallPatchMap.put(oldDexSign, indices);
                }
                indices.set(prevIndex);
            }
        }
    }

    public boolean isAffectedOldDex(String oldDexSign) {
        return this.oldDexSigns.contains(oldDexSign);
    }

    public boolean isSmallPatchedDexEmpty(String oldDexSign) {
        BitSet indices = this.oldDexSignToClassDefIndicesInSmallPatch.get(oldDexSign);
        return indices == null || indices.isEmpty();
    }

    public int getPatchedStringIdOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.stringIdsOffset : -1;
    }

    public int getPatchedTypeIdOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.typeIdsOffset : -1;
    }

    public int getPatchedProtoIdOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.protoIdsOffset : -1;
    }

    public int getPatchedFieldIdOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.fieldIdsOffset : -1;
    }

    public int getPatchedMethodIdOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.methodIdsOffset : -1;
    }

    public int getPatchedClassDefOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.classDefsOffset : -1;
    }

    public int getPatchedMapListOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.mapListOffset : -1;
    }

    public int getPatchedTypeListOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.typeListsOffset : -1;
    }

    public int getPatchedAnnotationSetRefListOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.annotationSetRefListsOffset : -1;
    }

    public int getPatchedAnnotationSetOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.annotationSetsOffset : -1;
    }

    public int getPatchedClassDataOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.classDataItemsOffset : -1;
    }

    public int getPatchedCodeOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.codeItemsOffset : -1;
    }

    public int getPatchedStringDataOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.stringDataItemsOffset : -1;
    }

    public int getPatchedDebugInfoOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.debugInfoItemsOffset : -1;
    }

    public int getPatchedAnnotationOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.annotationsOffset : -1;
    }

    public int getPatchedEncodedArrayOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.encodedArraysOffset : -1;
    }

    public int getPatchedAnnotationsDirectoryOffsetByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.annotationsDirectoriesOffset : -1;
    }

    public int getPatchedDexSizeByOldDexSign(String oldDexSign) {
        DexOffsets dexOffsets = this.oldDexSignToOffsetInfoMap.get(oldDexSign);
        return dexOffsets != null ? dexOffsets.dexSize : -1;
    }

    public boolean isStringInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToStringIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isTypeIdInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToTypeIdIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isTypeListInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToTypeListIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isProtoIdInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToProtoIdIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isFieldIdInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToFieldIdIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isMethodIdInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToMethodIdIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isAnnotationInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToAnnotationIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isAnnotationSetInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToAnnotationSetIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isAnnotationSetRefListInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToAnnotationSetRefListIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isAnnotationsDirectoryInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToAnnotationsDirectoryIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isEncodedArrayInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToEncodedArrayIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isDebugInfoInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToDebugInfoIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isCodeInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToCodeIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isClassDataInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToClassDataIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    public boolean isClassDefInSmallPatchedDex(String oldDexSign, int indexInPatchedDex) {
        BitSet indices = this.oldDexSignToClassDefIndicesInSmallPatch.get(oldDexSign);
        if (indices == null) {
            return false;
        }
        return indices.get(indexInPatchedDex);
    }

    private static final class DexOffsets {
        int stringIdsOffset = -1;
        int typeIdsOffset = -1;
        int protoIdsOffset = -1;
        int fieldIdsOffset = -1;
        int methodIdsOffset = -1;
        int classDefsOffset = -1;
        int mapListOffset = -1;
        int typeListsOffset = -1;
        int annotationsOffset = -1;
        int annotationSetsOffset = -1;
        int annotationSetRefListsOffset = -1;
        int annotationsDirectoriesOffset = -1;
        int classDataItemsOffset = -1;
        int codeItemsOffset = -1;
        int stringDataItemsOffset = -1;
        int debugInfoItemsOffset = -1;
        int encodedArraysOffset = -1;
        int dexSize = -1;

        private DexOffsets() {
        }
    }
}

