/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.commons.dexpatcher.algorithms.patch;

import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.MethodId;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dx.util.IndexMap;
import com.tencent.tinker.commons.dexpatcher.algorithms.patch.DexSectionPatchAlgorithm;
import com.tencent.tinker.commons.dexpatcher.struct.DexPatchFile;
import com.tencent.tinker.commons.dexpatcher.struct.SmallPatchedDexItemFile;

public class MethodIdSectionPatchAlgorithm
extends DexSectionPatchAlgorithm<MethodId> {
    private TableOfContents.Section patchedMethodIdTocSec = null;
    private Dex.Section patchedMethodIdSec = null;

    public MethodIdSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, IndexMap oldToFullPatchedIndexMap, IndexMap fullPatchedToSmallPatchedIndexMap, final SmallPatchedDexItemFile extraInfoFile) {
        this(patchFile, oldDex, patchedDex, oldToFullPatchedIndexMap, fullPatchedToSmallPatchedIndexMap, new DexSectionPatchAlgorithm.SmallPatchedDexItemChooser(){

            @Override
            public boolean isPatchedItemInSmallPatchedDex(String oldDexSign, int patchedItemIndex) {
                return extraInfoFile.isMethodIdInSmallPatchedDex(oldDexSign, patchedItemIndex);
            }
        });
    }

    public MethodIdSectionPatchAlgorithm(DexPatchFile patchFile, Dex oldDex, Dex patchedDex, IndexMap oldToFullPatchedIndexMap, IndexMap fullPatchedToSmallPatchedIndexMap, DexSectionPatchAlgorithm.SmallPatchedDexItemChooser spdItemChooser) {
        super(patchFile, oldDex, oldToFullPatchedIndexMap, fullPatchedToSmallPatchedIndexMap, spdItemChooser);
        if (patchedDex != null) {
            this.patchedMethodIdTocSec = patchedDex.getTableOfContents().methodIds;
            this.patchedMethodIdSec = patchedDex.openSection(this.patchedMethodIdTocSec);
        }
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().methodIds;
    }

    @Override
    protected MethodId nextItem(DexDataBuffer section) {
        return section.readMethodId();
    }

    @Override
    protected int getItemSize(MethodId item) {
        return item.byteCountInDex();
    }

    @Override
    protected int getFullPatchSectionBase() {
        if (this.patchFile != null) {
            return this.patchFile.getPatchedMethodIdSectionOffset();
        }
        return this.getTocSection((Dex)this.oldDex).off;
    }

    @Override
    protected MethodId adjustItem(IndexMap indexMap, MethodId item) {
        return indexMap.adjust(item);
    }

    @Override
    protected int writePatchedItem(MethodId patchedItem) {
        ++this.patchedMethodIdTocSec.size;
        return this.patchedMethodIdSec.writeMethodId(patchedItem);
    }

    @Override
    protected void updateIndexOrOffset(IndexMap indexMap, int oldIndex, int oldOffset, int newIndex, int newOffset) {
        if (oldIndex != newIndex) {
            indexMap.mapMethodIds(oldIndex, newIndex);
        }
    }

    @Override
    protected void markDeletedIndexOrOffset(IndexMap indexMap, int deletedIndex, int deletedOffset) {
        indexMap.markMethodIdDeleted(deletedIndex);
    }
}

