/*
 * Decompiled with CFR 0.152.
 */
package com.timqi.sectorprogressview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import com.timqi.sectorprogressview.R;

public class SectorProgressView
extends View {
    private int bgColor;
    private int fgColor;
    private Paint bgPaint;
    private Paint fgPaint;
    private RectF oval;
    private float percent;
    private float startAngle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SectorProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SectorProgressView, 0, 0);
        try {
            this.bgColor = a.getColor(R.styleable.SectorProgressView_bgColor, -1710619);
            this.fgColor = a.getColor(R.styleable.SectorProgressView_fgColor, -35236);
            this.percent = a.getFloat(R.styleable.SectorProgressView_percent, 0.0f);
            this.startAngle = a.getFloat(R.styleable.SectorProgressView_startAngle, 0.0f) + 270.0f;
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        this.bgPaint = new Paint();
        this.bgPaint.setColor(this.bgColor);
        this.fgPaint = new Paint();
        this.fgPaint.setColor(this.fgColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        float xpad = this.getPaddingLeft() + this.getPaddingRight();
        float ypad = this.getPaddingBottom() + this.getPaddingTop();
        float wwd = (float)w - xpad;
        float hhd = (float)h - ypad;
        this.oval = new RectF((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)this.getPaddingLeft() + wwd, (float)this.getPaddingTop() + hhd);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawArc(this.oval, 0.0f, 360.0f, true, this.bgPaint);
        canvas.drawArc(this.oval, this.startAngle, this.percent * 3.6f, true, this.fgPaint);
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
        this.refreshTheLayout();
    }

    public int getFgColor() {
        return this.fgColor;
    }

    public void setFgColor(int fgColor) {
        this.fgColor = fgColor;
        this.refreshTheLayout();
    }

    private void refreshTheLayout() {
        this.invalidate();
        this.requestLayout();
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(float startAngle) {
        this.startAngle = startAngle + 270.0f;
        this.invalidate();
        this.requestLayout();
    }

    public float getPercent() {
        return this.percent;
    }

    public void setPercent(float percent) {
        this.percent = percent;
        this.invalidate();
        this.requestLayout();
    }
}

