/*
 * Decompiled with CFR 0.152.
 */
package com.timqi.sectorprogressview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Shader;
import android.util.AttributeSet;
import android.view.View;
import com.timqi.sectorprogressview.R;

public class ColorfulRingProgressView
extends View {
    private float mPercent = 75.0f;
    private float mStrokeWidth;
    private int mBgColor = -1973791;
    private float mStartAngle = 0.0f;
    private int mFgColorStart = -7168;
    private int mFgColorEnd = -47104;
    private LinearGradient mShader;
    private Context mContext;
    private RectF mOval;
    private Paint mPaint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorfulRingProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.ColorfulRingProgressView, 0, 0);
        try {
            this.mBgColor = a.getColor(R.styleable.ColorfulRingProgressView_bgColor, -1973791);
            this.mFgColorEnd = a.getColor(R.styleable.ColorfulRingProgressView_fgColorEnd, -47104);
            this.mFgColorStart = a.getColor(R.styleable.ColorfulRingProgressView_fgColorStart, -7168);
            this.mPercent = a.getFloat(R.styleable.ColorfulRingProgressView_percent, 75.0f);
            this.mStartAngle = a.getFloat(R.styleable.ColorfulRingProgressView_startAngle, 0.0f) + 270.0f;
            this.mStrokeWidth = a.getDimensionPixelSize(R.styleable.ColorfulRingProgressView_strokeWidth, this.dp2px(21.0f));
            System.out.println("**** m" + this.mStrokeWidth);
        }
        finally {
            a.recycle();
        }
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    private int dp2px(float dp) {
        return (int)(this.mContext.getResources().getDisplayMetrics().density * dp + 0.5f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setShader(null);
        this.mPaint.setColor(this.mBgColor);
        canvas.drawArc(this.mOval, 0.0f, 360.0f, false, this.mPaint);
        this.mPaint.setShader((Shader)this.mShader);
        canvas.drawArc(this.mOval, this.mStartAngle, this.mPercent * 3.6f, false, this.mPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.updateOval();
        this.mShader = new LinearGradient(this.mOval.left, this.mOval.top, this.mOval.left, this.mOval.bottom, this.mFgColorStart, this.mFgColorEnd, Shader.TileMode.MIRROR);
    }

    public float getPercent() {
        return this.mPercent;
    }

    public void setPercent(float mPercent) {
        this.mPercent = mPercent;
        this.refreshTheLayout();
    }

    public float getStrokeWidth() {
        return this.mStrokeWidth;
    }

    public void setStrokeWidth(float mStrokeWidth) {
        this.mStrokeWidth = mStrokeWidth;
        this.mPaint.setStrokeWidth(mStrokeWidth);
        this.updateOval();
        this.refreshTheLayout();
    }

    private void updateOval() {
        int xp = this.getPaddingLeft() + this.getPaddingRight();
        int yp = this.getPaddingBottom() + this.getPaddingTop();
        this.mOval = new RectF((float)this.getPaddingLeft() + this.mStrokeWidth, (float)this.getPaddingTop() + this.mStrokeWidth, (float)(this.getPaddingLeft() + (this.getWidth() - xp)) - this.mStrokeWidth, (float)(this.getPaddingTop() + (this.getHeight() - yp)) - this.mStrokeWidth);
    }

    public void setStrokeWidthDp(float dp) {
        this.mStrokeWidth = this.dp2px(dp);
        this.mPaint.setStrokeWidth(this.mStrokeWidth);
        this.updateOval();
        this.refreshTheLayout();
    }

    public void refreshTheLayout() {
        this.invalidate();
        this.requestLayout();
    }

    public int getFgColorStart() {
        return this.mFgColorStart;
    }

    public void setFgColorStart(int mFgColorStart) {
        this.mFgColorStart = mFgColorStart;
        this.mShader = new LinearGradient(this.mOval.left, this.mOval.top, this.mOval.left, this.mOval.bottom, mFgColorStart, this.mFgColorEnd, Shader.TileMode.MIRROR);
        this.refreshTheLayout();
    }

    public int getFgColorEnd() {
        return this.mFgColorEnd;
    }

    public void setFgColorEnd(int mFgColorEnd) {
        this.mFgColorEnd = mFgColorEnd;
        this.mShader = new LinearGradient(this.mOval.left, this.mOval.top, this.mOval.left, this.mOval.bottom, this.mFgColorStart, mFgColorEnd, Shader.TileMode.MIRROR);
        this.refreshTheLayout();
    }

    public float getStartAngle() {
        return this.mStartAngle;
    }

    public void setStartAngle(float mStartAngle) {
        this.mStartAngle = mStartAngle + 270.0f;
        this.refreshTheLayout();
    }
}

