/*
 * Decompiled with CFR 0.152.
 */
package com.timper.view.loading;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.timper.view.loading.Indicator;
import java.util.ArrayList;

public class LoadingIndicator
extends Indicator {
    float[] translateX = new float[2];
    float[] translateY = new float[2];

    @Override
    public void draw(Canvas canvas, Paint paint) {
        for (int i = 0; i < 2; ++i) {
            if (i == 0) {
                paint.setColor(Color.parseColor((String)"#00bebe"));
            } else {
                paint.setColor(Color.parseColor((String)"#00dada"));
            }
            canvas.save();
            canvas.translate(this.translateX[i], 20.0f);
            canvas.drawCircle(0.0f, 0.0f, (float)(this.getWidth() / 10), paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        float startX = this.getWidth() / 6;
        for (int i = 0; i < 2; ++i) {
            final int index = i;
            ValueAnimator translateXAnim = ValueAnimator.ofFloat((float[])new float[]{startX, (float)this.getWidth() - startX, startX});
            if (i == 1) {
                translateXAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startX, startX, (float)this.getWidth() - startX});
            }
            translateXAnim.setDuration(1000L);
            translateXAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translateXAnim.setRepeatCount(-1);
            this.addUpdateListener(translateXAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    LoadingIndicator.this.translateX[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    LoadingIndicator.this.postInvalidate();
                }
            });
            animators.add(translateXAnim);
        }
        return animators;
    }
}

