package com.tigether.logger;

import com.orhanobut.logger.AndroidLogAdapter;
import com.orhanobut.logger.FormatStrategy;
import com.orhanobut.logger.Logger;
import com.orhanobut.logger.PrettyFormatStrategy;

/**
 * Created by gaohang on 16/11/23.
 * Log统一管理类
 */


public class LogUtil {
    // 是否需要打印bug，可以在application的onCreate函数里面初始化
    private static boolean isDebug = true;
    private static final String TAG = "LogUtil";

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setIsDebug(boolean isDebug) {
        LogUtil.isDebug = isDebug;
    }

    /**
     * 设置日志打印的策略
     *
     * @param isDebug
     */
    public static void initLogger(Boolean isDebug) {
        LogUtil.isDebug = isDebug;
        FormatStrategy formatStrategy = PrettyFormatStrategy.newBuilder()
                .showThreadInfo(false)  // (Optional) Whether to show thread info or not. Default true
                .tag(TAG)   // (Optional) Global tag for every log. Default PRETTY_LOGGER
                .build();
        Logger.addLogAdapter(new AndroidLogAdapter(formatStrategy));
    }

    private LogUtil() {
        /* cannot be instantiated */
        throw new UnsupportedOperationException("cannot be instantiated");
    }

    // 下面四个是默认tag的函数
    public static void i(String msg) {
        if (isDebug) {
            Logger.i(msg);
        }
    }

    public static void d(String msg) {
        if (isDebug) {
            Logger.d(msg);
        }
    }

    public static void w(String tag, String msg, Exception e) {
        if (isDebug) {
            Logger.w(msg, e);
        }
    }

    public static void e(String msg) {
        if (isDebug) {
            Logger.e(msg);
        }
    }

    public static void v(String msg) {
        if (isDebug) {
            Logger.v(msg);
        }
    }

    // 下面是传入自定义tag的函数
    public static void i(String tag, String msg) {
        if (isDebug) {
            Logger.i("tag:%s  data:%s", tag, msg);
        }
    }

    public static void d(String tag, String msg) {
        if (isDebug) {
            Logger.d("tag:%s  data:%s", tag, msg);
        }
    }

    public static void e(String tag, String msg) {
        if (isDebug) {
            Logger.e("tag:%s  data:%s", tag, msg);
        }
    }

    public static void e(String tag, String msg, Exception e) {
        if (isDebug) {
            Logger.e("tag:%s  data:%s exception:%s", tag, msg, e.getMessage());

        }
    }

    public static void v(String tag, String msg) {
        if (isDebug) {
            Logger.v("tag:%s  data:%s", tag, msg);
        }
    }
}

