/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml.processor.converter;

import com.tickaroo.tikxml.TypeConverter;
import com.tickaroo.tikxml.processor.ProcessingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J#\u0010\u0005\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u00030\u00070\u00062\u0006\u0010\b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/tickaroo/tikxml/processor/converter/ConverterChecker;", "T", "", "", "()V", "getConverterFromAnnotation", "Lkotlin/reflect/KClass;", "Lcom/tickaroo/tikxml/TypeConverter;", "annotation", "(Ljava/lang/annotation/Annotation;)Lkotlin/reflect/KClass;", "getQualifiedConverterName", "", "element", "Ljavax/lang/model/element/Element;", "(Ljavax/lang/model/element/Element;Ljava/lang/annotation/Annotation;)Ljava/lang/String;", "processor-common"})
public abstract class ConverterChecker<T extends Annotation> {
    @Nullable
    public final String getQualifiedConverterName(@NotNull Element element, @NotNull T annotation) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Intrinsics.checkParameterIsNotNull(annotation, (String)"annotation");
        try {
            Class converterClass = JvmClassMappingKt.getJavaClass(this.getConverterFromAnnotation(annotation));
            if (Intrinsics.areEqual((Object)converterClass, TypeConverter.NoneTypeConverter.class)) {
                return null;
            }
            if (!Modifier.isPublic(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " must be a public class!");
            }
            if (Modifier.isAbstract(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " cannot be a abstract");
            }
            if (Modifier.isInterface(converterClass.getModifiers())) {
                throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " cannot be an interface. Only classes are allowed!");
            }
            Constructor<?>[] constructors = converterClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> c = constructors[i];
                boolean bl = Modifier.isPublic(c.getModifiers());
                Class<?>[] paramTypes = c.getParameterTypes();
                Object[] objectArray = paramTypes;
                if (!(objectArray.length == 0) || !bl) continue;
                return converterClass.getCanonicalName();
            }
            throw (Throwable)new ProcessingException(element, "TypeConverter class " + converterClass.getCanonicalName() + " must provide an empty (parameter-less) public constructor");
        }
        catch (MirroredTypeException mte) {
            TypeMirror typeMirror = mte.getTypeMirror();
            if (Intrinsics.areEqual((Object)((Object)typeMirror).toString(), (Object)Reflection.getOrCreateKotlinClass(TypeConverter.NoneTypeConverter.class).getQualifiedName())) {
                return null;
            }
            if (Intrinsics.areEqual((Object)((Object)typeMirror.getKind()), (Object)((Object)TypeKind.DECLARED)) ^ true) {
                throw (Throwable)new ProcessingException(element, "TypeConverter must be a class");
            }
            TypeMirror typeMirror2 = typeMirror;
            if (typeMirror2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.type.DeclaredType");
            }
            DeclaredType typeConverterType = (DeclaredType)typeMirror2;
            Element typeConverterElement = typeConverterType.asElement();
            if (Intrinsics.areEqual((Object)((Object)typeConverterElement.getKind()), (Object)((Object)ElementKind.CLASS)) ^ true) {
                throw (Throwable)new ProcessingException(element, "TypeConverter " + typeConverterElement + " must be a public class!");
            }
            if (!typeConverterElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC)) {
                throw (Throwable)new ProcessingException(element, "TypeConverter " + typeConverterElement + " class is not public!");
            }
            Element element2 = typeConverterElement;
            if (element2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.TypeElement");
            }
            for (Element element3 : ((TypeElement)element2).getEnclosedElements()) {
                if (!Intrinsics.areEqual((Object)((Object)element3.getKind()), (Object)((Object)ElementKind.CONSTRUCTOR))) continue;
                Element element4 = element3;
                if (element4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.lang.model.element.ExecutableElement");
                }
                ExecutableElement constructor = (ExecutableElement)element4;
                if (!constructor.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC) || !constructor.getParameters().isEmpty()) continue;
                return ((Object)typeMirror).toString();
            }
            throw (Throwable)new ProcessingException(element, "TypeConverter class " + typeMirror + " must provide an empty (parameter-less) public constructor");
        }
    }

    @NotNull
    protected abstract KClass<? extends TypeConverter<Object>> getConverterFromAnnotation(@NotNull T var1);
}

