/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.sourcemonitor;

import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorReport;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorResult;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorSummary;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.Serializable;
import org.kohsuke.stapler.StaplerProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMonitorBuildAction
implements Action,
Serializable,
StaplerProxy {
    public static final String URL_NAME = "sourcemonitor";
    private AbstractBuild<?, ?> build;
    private SourceMonitorResult result;

    public SourceMonitorBuildAction(AbstractBuild<?, ?> build, SourceMonitorResult result) {
        this.build = build;
        this.result = result;
    }

    public String getIconFileName() {
        return "/plugin/sourcemonitor/icons/sourcemonitor-24.png";
    }

    public String getDisplayName() {
        return "SourceMonitor Results";
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public String getSummary() {
        return SourceMonitorSummary.createReportSummary(this.result.getReport(), this.getPreviousReport());
    }

    public String getDetails() {
        return SourceMonitorSummary.createReportSummaryDetails(this.result.getReport(), this.getPreviousReport());
    }

    public SourceMonitorResult getResult() {
        return this.result;
    }

    private SourceMonitorReport getPreviousReport() {
        SourceMonitorResult previous = this.getPreviousResult();
        if (previous == null) {
            return null;
        }
        return previous.getReport();
    }

    SourceMonitorResult getPreviousResult() {
        SourceMonitorBuildAction previousAction = this.getPreviousAction();
        SourceMonitorResult previousResult = null;
        if (previousAction != null) {
            previousResult = previousAction.getResult();
        }
        return previousResult;
    }

    SourceMonitorBuildAction getPreviousAction() {
        AbstractBuild previousBuild = (AbstractBuild)this.build.getPreviousBuild();
        if (previousBuild != null) {
            return (SourceMonitorBuildAction)previousBuild.getAction(SourceMonitorBuildAction.class);
        }
        return null;
    }

    AbstractBuild<?, ?> getBuild() {
        return this.build;
    }

    public Object getTarget() {
        return this.result;
    }
}

