/*
 * Decompiled with CFR 0.152.
 */
package com.testvagrant.optimuscloud.local;

import com.testvagrant.optimuscloud.entities.MobileDriverDetails;
import com.testvagrant.optimuscloud.local.WDAServerFlag;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.flags.AndroidServerFlag;
import io.appium.java_client.service.local.flags.ServerArgument;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class OptimusLocalDriver {
    private MobileDriver mobileDriver;
    private AppiumDriverLocalService appiumService;

    public MobileDriverDetails createDriver(DesiredCapabilities desiredCapabilities) {
        this.appiumService = this.createAppiumService(desiredCapabilities);
        this.launchAppiumService(this.appiumService);
        this.mobileDriver = this.addDriver(this.appiumService.getUrl(), desiredCapabilities);
        return this.mapDriver(this.mobileDriver, desiredCapabilities);
    }

    private void launchAppiumService(AppiumDriverLocalService appiumService) {
        appiumService.start();
        while (!appiumService.isRunning()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void killDriver() {
        this.appiumService.stop();
    }

    private MobileDriverDetails mapDriver(MobileDriver mobileDriver, DesiredCapabilities desiredCapabilities) {
        MobileDriverDetails mobileDriverDetails = new MobileDriverDetails();
        mobileDriverDetails.setDesiredCapabilities(desiredCapabilities);
        mobileDriverDetails.setMobileDriver(mobileDriver);
        return mobileDriverDetails;
    }

    private AppiumDriverLocalService createAppiumService(DesiredCapabilities desiredCapabilities) {
        AppiumServiceBuilder serviceBuilder = new AppiumServiceBuilder().usingAnyFreePort();
        if (desiredCapabilities.getPlatform().is(Platform.ANDROID)) {
            serviceBuilder.withArgument((ServerArgument)AndroidServerFlag.BOOTSTRAP_PORT_NUMBER, String.valueOf(this.findRandomOpenPortOnAllLocalInterfaces()));
        } else {
            serviceBuilder.withArgument((ServerArgument)WDAServerFlag.WDA_PORT, String.valueOf(this.findRandomOpenPortOnAllLocalInterfaces()));
        }
        return (AppiumDriverLocalService)serviceBuilder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer findRandomOpenPortOnAllLocalInterfaces() {
        try (ServerSocket socket = new ServerSocket(0);){
            Integer n = socket.getLocalPort();
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Cannot find open port");
        }
    }

    public MobileDriver addDriver(URL url, DesiredCapabilities capabilities) {
        try {
            return this.setUpDevice(url, capabilities);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new RuntimeException("Driver could not be created for -- " + capabilities.getCapability("udid"));
        }
    }

    private AppiumDriver setUpDevice(URL url, DesiredCapabilities capabilities) throws MalformedURLException {
        if (capabilities.getPlatform().is(Platform.ANDROID)) {
            return new AndroidDriver(url, (Capabilities)capabilities);
        }
        return new IOSDriver(url, (Capabilities)capabilities);
    }
}

