package com.testvagrant.optimuscloud.driver;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.NoSuchSessionException;

public class DriverCreatorFactory {

    public static DriverCreator getInstance(String sessionUrl, Capabilities desiredCapabilities) {
        switch (desiredCapabilities.getCapability("platformName").toString().toLowerCase()) {
            case "android":
                return new AndroidDriverCreator(sessionUrl,desiredCapabilities);
            case "ios":
                return new IosDriverCreator(sessionUrl,desiredCapabilities);
            default: throw new RuntimeException("Cannot find platformName capability to create a new driver");
        }
    }
}
