/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.maven.mojo;

import com.testquack.beans.TestCase;
import com.testquack.maven.client.QuackClient;
import com.testquack.maven.client.QuackClietnUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.Test;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;
import retrofit2.Response;
import ru.greatbit.utils.string.StringUtils;

@Mojo(name="junit-import", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES)
public class QuackJunitImport
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject mavenProject;
    @Parameter(defaultValue="false")
    private boolean failOnError;
    @Parameter(property="quackProject", name="quackProject", required=true)
    private String quackProject;
    @Parameter(property="apiToken", name="apiToken", required=true)
    private String apiToken;
    @Parameter(property="apiEndpoint", name="apiEndpoint", required=true)
    private String apiEndpoint;
    @Parameter(property="apiTimeout", name="apiTimeout", defaultValue="60000")
    private long apiTimeout;
    @Parameter(property="uploadChunkSize", name="uploadChunkSize", defaultValue="20")
    private int uploadChunkSize;
    @Parameter(property="importResource", name="importResource", defaultValue="maven-junit:${project.groupId}:${project.artifactId}")
    private String importResource;

    public void execute() {
        this.getLog().info((CharSequence)"Preparing QuAck Project data");
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setUrls(this.getTestClasspathUrls()).setScanners(new Scanner[]{new MethodAnnotationsScanner(), new SubTypesScanner(), new TypeAnnotationsScanner()}).addClassLoader(this.getClassLoader()));
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
        Set methods = reflections.getMethodsAnnotatedWith(Test.class);
        List<TestCase> testCases = methods.stream().map(this::convert).collect(Collectors.toList());
        this.uploadTestcases(testCases);
    }

    private void uploadTestcases(List<TestCase> testCases) {
        this.getLog().info((CharSequence)String.format("Found %s testcases to upload", testCases.size()));
        QuackClient client = QuackClietnUtils.getClient(this.apiToken, this.apiEndpoint, this.apiTimeout);
        this.getLog().debug((CharSequence)String.format("Marking testcase of import resource %s as obsolete", this.importResource));
        try {
            client.deleteTestcasesByImportResource(this.quackProject, this.importResource).execute();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)String.format("Unable to obsolete testcase for import resource %s", this.importResource), (Throwable)e);
            throw new RuntimeException(e);
        }
        this.getLog().info((CharSequence)String.format("Sending testcases to QuAck in chunks by %s", this.uploadChunkSize));
        List partitions = ListUtils.partition(testCases, (int)this.uploadChunkSize);
        for (int i = 0; i < partitions.size(); ++i) {
            try {
                Response response = client.importTestCases(this.quackProject, (List)partitions.get(i)).execute();
                if (!response.isSuccessful()) {
                    String errorMsg = String.format("Unable to upload testcases to QuAck, got response %s", response.toString());
                    this.getLog().error((CharSequence)errorMsg);
                    throw new RuntimeException(errorMsg);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Unable to upload testcases to QuAck", (Throwable)e);
                throw new RuntimeException(e);
            }
            this.getLog().info((CharSequence)String.format("Uploaded %s %%", Math.min(100, (i + 1) * this.uploadChunkSize * 100 / testCases.size())));
        }
    }

    private TestCase convert(Method method) {
        TestCase testCase = (TestCase)new TestCase().withImportedName(method.getName()).withAlias(this.getHash(method)).withImportResource(this.importResource).withAutomated(true);
        testCase.getMetaData().put("class", method.getDeclaringClass());
        testCase.getMetaData().put("method", method.getName());
        testCase.getMetaData().put("parameters", Stream.of(method.getParameterTypes()).map(Class::getName).collect(Collectors.toList()));
        testCase.getMetaData().put("groupId", this.mavenProject.getGroupId());
        testCase.getMetaData().put("artifactId", this.mavenProject.getArtifactId());
        testCase.getMetaData().put("version", this.mavenProject.getVersion());
        return testCase;
    }

    private String getHash(Method method) {
        try {
            return StringUtils.getMd5String((String)(method.getDeclaringClass().getCanonicalName() + "." + method.getName()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to create hash for the method " + method, e);
        }
    }

    private ClassLoader getClassLoader() {
        return new URLClassLoader(this.getTestClasspathUrls(), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private URL[] getTestClasspathUrls() {
        try {
            List classpathElements = this.mavenProject.getTestCompileSourceRoots();
            classpathElements.addAll(this.mavenProject.getTestClasspathElements());
            classpathElements.add(this.mavenProject.getBuild().getTestOutputDirectory());
            this.getLog().debug((CharSequence)("Classpath " + classpathElements));
            return (URL[])classpathElements.stream().filter(Objects::nonNull).map(File::new).map(File::toURI).map(this::toUrl).filter(Objects::nonNull).toArray(URL[]::new);
        }
        catch (DependencyResolutionRequiredException e) {
            return new URL[0];
        }
    }

    private URL toUrl(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            this.getLog().debug((CharSequence)"Couldn't get the classloader.");
            return null;
        }
    }
}

