/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.model.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum APIPaymentMethod {
    PAYPAL(Collections.emptyMap()),
    BRAINTREE(APIPaymentMethod.createBraintreeMapping()),
    STRIPE(APIPaymentMethod.createStripeMapping()),
    INVOICE(APIPaymentMethod.createInvoiceMapping()),
    PROMOTION(Collections.emptyMap()),
    AWS(Collections.emptyMap()),
    CBT(APIPaymentMethod.createCBTMapping());

    private final Map<List<Boolean>, List<PlanOperation>> operationSchema;

    private static Map<List<Boolean>, List<PlanOperation>> createInvoiceMapping() {
        HashMap<List<Boolean>, List<PlanOperation>> result = new HashMap<List<Boolean>, List<PlanOperation>>();
        result.put(Arrays.asList(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE), Collections.singletonList(PlanOperation.CREATE));
        result.put(Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE), Collections.singletonList(PlanOperation.CREATE));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE), Collections.singletonList(PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.FALSE, Boolean.TRUE, Boolean.FALSE), Collections.singletonList(PlanOperation.ACTIVATE));
        result.put(Arrays.asList(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE));
        result.put(Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE, PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, Boolean.FALSE), Arrays.asList(PlanOperation.ACTIVATE, PlanOperation.CANCEL));
        return Collections.unmodifiableMap(result);
    }

    private static Map<List<Boolean>, List<PlanOperation>> createBraintreeMapping() {
        HashMap<List<Boolean>, List<PlanOperation>> result = new HashMap<List<Boolean>, List<PlanOperation>>();
        result.put(Arrays.asList(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE), Collections.singletonList(PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE), Collections.singletonList(PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE, PlanOperation.CANCEL));
        return Collections.unmodifiableMap(result);
    }

    private static Map<List<Boolean>, List<PlanOperation>> createStripeMapping() {
        HashMap<List<Boolean>, List<PlanOperation>> result = new HashMap<List<Boolean>, List<PlanOperation>>();
        result.put(Arrays.asList(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.TRUE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE), Collections.singletonList(PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE), Collections.singletonList(PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.TRUE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE, PlanOperation.CANCEL));
        return Collections.unmodifiableMap(result);
    }

    private static Map<List<Boolean>, List<PlanOperation>> createCBTMapping() {
        HashMap<List<Boolean>, List<PlanOperation>> result = new HashMap<List<Boolean>, List<PlanOperation>>();
        result.put(Arrays.asList(Boolean.TRUE, Boolean.FALSE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE));
        result.put(Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE), Arrays.asList(PlanOperation.CREATE, PlanOperation.ACTIVATE, PlanOperation.CANCEL));
        result.put(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE), Collections.singletonList(PlanOperation.CANCEL));
        return Collections.unmodifiableMap(result);
    }

    private APIPaymentMethod(Map<List<Boolean>, List<PlanOperation>> operationSchema) {
        this.operationSchema = operationSchema;
    }

    public boolean canChange(boolean byUser) {
        return this.getOperationSchema().containsKey(Arrays.asList(Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, byUser)) || this.getOperationSchema().containsKey(Arrays.asList(Boolean.FALSE, Boolean.TRUE, Boolean.TRUE, byUser));
    }

    public Map<List<Boolean>, List<PlanOperation>> getOperationSchema() {
        return this.operationSchema;
    }

    public static enum PlanOperation {
        CANCEL,
        CREATE,
        ACTIVATE;

    }
}

