/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api.filter;

import com.testdroid.api.dto.Operand;
import com.testdroid.api.util.TimeConverter;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class FilterEntry {
    private static final String ARG_DELIMITER = "|";
    private String field;
    private Operand operand;
    private String rawValue = "";

    public FilterEntry(String field, Operand operand, Object value) {
        this.field = Objects.requireNonNull(field);
        this.operand = Objects.requireNonNull(operand);
        this.rawValue = this.valueToString(value);
        this.validate();
    }

    public FilterEntry(String field, Operand operand) {
        this.field = Objects.requireNonNull(field);
        this.operand = Objects.requireNonNull(operand);
        this.validate();
    }

    private FilterEntry(String field, Operand operand, String rawValue) {
        this.field = Objects.requireNonNull(field);
        this.operand = Objects.requireNonNull(operand);
        this.rawValue = rawValue;
        this.validate();
    }

    public String getField() {
        return this.field;
    }

    public FilterEntry setField(String field) {
        this.field = field;
        return this;
    }

    public Operand getOperand() {
        return this.operand;
    }

    public FilterEntry setOperand(Operand operand) {
        this.operand = operand;
        return this;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public static FilterEntry create(String field, Operand operand, String rawValue) {
        return new FilterEntry(field, operand, rawValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterEntry that = (FilterEntry)o;
        return Objects.equals(this.field, that.field) && this.operand == that.operand && StringUtils.equalsIgnoreCase((CharSequence)this.rawValue, (CharSequence)that.rawValue);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.operand, this.rawValue});
    }

    public String toString() {
        String result = String.format("%s_%s", new Object[]{this.field, this.operand});
        return StringUtils.isNotBlank((CharSequence)this.rawValue) ? String.format("%s_%s", result, this.rawValue) : result;
    }

    public static FilterEntry trueFilterEntry(String field) {
        return new FilterEntry(field, Operand.EQ, Boolean.TRUE);
    }

    public static FilterEntry falseFilterEntry(String field) {
        return new FilterEntry(field, Operand.EQ, Boolean.FALSE);
    }

    public static FilterEntry nullFilterEntry(String field) {
        return new FilterEntry(field, Operand.ISNULL);
    }

    public static FilterEntry notNullFilterEntry(String field) {
        return new FilterEntry(field, Operand.ISNOTNULL);
    }

    private String valueToString(Object value) {
        switch (this.operand.getArity()) {
            case 1: {
                return null;
            }
            case 2: {
                return this.singleToString(value);
            }
        }
        return ((List)value).stream().map(this::singleToString).collect(Collectors.joining(ARG_DELIMITER));
    }

    private void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.rawValue) && this.operand.getArity().equals(1)) {
            throw new IllegalArgumentException("Operand does not accept any value");
        }
        if (StringUtils.isBlank((CharSequence)this.rawValue) && this.operand.getArity().equals(Integer.MAX_VALUE)) {
            throw new IllegalArgumentException("Operand requires a list of values");
        }
    }

    private String singleToString(Object value) {
        if (LocalDateTime.class == value.getClass()) {
            return String.valueOf(TimeConverter.toMilli((LocalDateTime)value));
        }
        return value.toString();
    }
}

