/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.tersesystems.echopraxia.spi.CoreLogger;
import com.tersesystems.echopraxia.spi.CoreLoggerFactory;
import com.tersesystems.echopraxia.spi.CoreLoggerFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class Filters {
    private final List<CoreLoggerFilter> filterList;
    private static final String PROPERTIES_FILE = "echopraxia.properties";

    public Filters(@NotNull ClassLoader[] classLoaders) {
        InputStream inputStream = CoreLoggerFactory.class.getResourceAsStream("/echopraxia.properties");
        if (inputStream != null) {
            try {
                Properties props = new Properties();
                props.load(inputStream);
                this.filterList = this.getFilters(props, classLoaders);
            }
            catch (IOException e) {
                throw new ServiceConfigurationError(e.getMessage(), e);
            }
        } else {
            this.filterList = Collections.emptyList();
        }
    }

    public Filters(List<CoreLoggerFilter> filterList) {
        this.filterList = filterList;
    }

    @NotNull
    private List<CoreLoggerFilter> getFilters(@NotNull Properties props, @NotNull ClassLoader[] classLoaders) {
        String value;
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while ((value = props.getProperty("filter." + i)) != null) {
            result.add(value);
            ++i;
        }
        Stream stream = result.stream();
        return stream.map(className -> this.getFilterInstance(classLoaders, (String)className)).collect(Collectors.toList());
    }

    Class<?> loadClass(@NotNull ClassLoader[] classLoaders, @NotNull String className) throws ClassNotFoundException {
        ArrayList<ClassNotFoundException> exceptions = new ArrayList<ClassNotFoundException>();
        for (int i = 0; i < classLoaders.length; ++i) {
            try {
                ClassLoader classLoader = classLoaders[i];
                return Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                exceptions.add(e);
                continue;
            }
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            try {
                return Class.forName(className, true, contextClassLoader);
            }
            catch (ClassNotFoundException e) {
                exceptions.add(e);
            }
        }
        @NotNull String msg = "No class found " + className + " using classLoaders " + Arrays.asList(classLoaders) + ", exceptions = " + exceptions;
        throw new ClassNotFoundException(msg);
    }

    @NotNull
    private CoreLoggerFilter getFilterInstance(@NotNull ClassLoader[] classLoaders, @NotNull String className) {
        try {
            Class<?> aClass = this.loadClass(classLoaders, className);
            if (!CoreLoggerFilter.class.isAssignableFrom(aClass)) {
                String msg = "Class " + className + " does not implement CoreLoggerFilter";
                throw new ServiceConfigurationError(msg);
            }
            Class<?> filterClass = aClass;
            Constructor<?> declaredConstructor = filterClass.getDeclaredConstructor(new Class[0]);
            return (CoreLoggerFilter)declaredConstructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServiceConfigurationError("Cannot create an instance from " + className + ": " + e.getMessage(), e);
        }
    }

    @NotNull
    public CoreLogger apply(@NotNull CoreLogger core) {
        CoreLogger c = core;
        int filterListSize = this.filterList.size();
        for (int i = 0; i < filterListSize; ++i) {
            CoreLoggerFilter next = this.filterList.get(i);
            c = (CoreLogger)next.apply(c);
        }
        return c;
    }
}

