/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public interface FieldBuilderResult {
    @NotNull
    public List<Field> fields();

    @NotNull
    public static FieldBuilderResult empty() {
        return Collections::emptyList;
    }

    @NotNull
    public static FieldBuilderResult only(@NotNull Field field) {
        return () -> Collections.singletonList(field);
    }

    @NotNull
    public static FieldBuilderResult list(@NotNull List<Field> list) {
        return () -> list;
    }

    @NotNull
    public static FieldBuilderResult list(@NotNull Field[] array) {
        return () -> Arrays.asList(array);
    }

    @NotNull
    public static FieldBuilderResult list(@NotNull Iterable<Field> iterable) {
        return FieldBuilderResult.list(iterable.spliterator());
    }

    @NotNull
    public static FieldBuilderResult list(@NotNull Spliterator<Field> fieldSpliterator) {
        return FieldBuilderResult.list(StreamSupport.stream(fieldSpliterator, false));
    }

    @NotNull
    public static FieldBuilderResult list(@NotNull Iterator<Field> iterator) {
        return FieldBuilderResult.list(Spliterators.spliteratorUnknownSize(iterator, 0));
    }

    @NotNull
    public static FieldBuilderResult list(@NotNull Stream<Field> stream) {
        return FieldBuilderResult.list(stream.collect(Collectors.toList()));
    }
}

