/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Conditions;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Level;
import com.tersesystems.echopraxia.api.LoggingContext;
import com.tersesystems.echopraxia.api.Value;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface Condition {
    public boolean test(Level var1, LoggingContext var2);

    default public Condition and(Condition c) {
        return (level, context) -> this.test(level, context) && c.test(level, context);
    }

    default public Condition or(Condition c) {
        return (level, context) -> this.test(level, context) || c.test(level, context);
    }

    default public Condition xor(Condition c) {
        return (level, context) -> this.test(level, context) ^ c.test(level, context);
    }

    public static Condition always() {
        return Conditions.ALWAYS;
    }

    public static Condition never() {
        return Conditions.NEVER;
    }

    public static Condition threshold(Level threshold) {
        return (level, context) -> level.isGreaterOrEqual(threshold);
    }

    public static Condition exactly(Level exactLevel) {
        return (level, context) -> level.isEqual(exactLevel);
    }

    public static Condition diagnostic() {
        return (level, context) -> level.isLessOrEqual(Level.DEBUG);
    }

    public static Condition operational() {
        return (level, context) -> level.isGreaterOrEqual(Level.INFO);
    }

    public static Condition anyMatch(Predicate<Field> predicate) {
        return (level, ctx) -> ctx.getFields().stream().anyMatch(predicate);
    }

    public static Condition noneMatch(Predicate<Field> predicate) {
        return (level, ctx) -> ctx.getFields().stream().noneMatch(predicate);
    }

    @Contract(pure=true)
    @NotNull
    public static Condition valueMatch(String fieldName, Predicate<Value<?>> predicate) {
        return (level, ctx) -> ctx.getFields().stream().filter(f -> f.name().equals(fieldName)).map(Field::value).anyMatch(predicate);
    }

    public static Condition stringMatch(String fieldName, Predicate<Value<String>> predicate) {
        return (level, ctx) -> ctx.getFields().stream().filter(f -> f.name().equals(fieldName)).filter(f -> f.value().type() == Value.Type.STRING).map(f -> (Value.StringValue)f.value()).anyMatch(predicate);
    }

    public static Condition numberMatch(String fieldName, Predicate<? super Value.NumberValue<?>> predicate) {
        return (level, ctx) -> ctx.getFields().stream().filter(f -> f.name().equals(fieldName)).filter(f -> f.value().type() == Value.Type.NUMBER).map(f -> (Value.NumberValue)f.value()).anyMatch(predicate);
    }

    public static Condition booleanMatch(String fieldName, Predicate<Value<Boolean>> predicate) {
        return (level, ctx) -> ctx.getFields().stream().filter(f -> f.name().equals(fieldName)).filter(f -> f.value().type() == Value.Type.BOOLEAN).map(f -> (Value.BooleanValue)f.value()).anyMatch(predicate);
    }

    public static Condition arrayMatch(String fieldName, Predicate<Value<List<Value<?>>>> predicate) {
        return (level, ctx) -> ctx.getFields().stream().filter(f -> f.name().equals(fieldName)).filter(f -> f.value().type() == Value.Type.ARRAY).map(f -> (Value.ArrayValue)f.value()).anyMatch(predicate);
    }

    public static Condition objectMatch(String fieldName, Predicate<Value<List<Field>>> predicate) {
        return (level, ctx) -> ctx.getFields().stream().filter(f -> f.name().equals(fieldName)).filter(f -> f.value().type() == Value.Type.OBJECT).map(f -> (Value.ObjectValue)f.value()).anyMatch(predicate);
    }
}

