/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.api;

import android.content.Context;
import com.google.gson.Gson;
import com.tenqube.visual_third.api.VisualApiService;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.AnalysisResponse;
import com.tenqube.visual_third.model.api.CurrencyResponse;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.api.SignUpRequest;
import com.tenqube.visual_third.model.api.SignUpResponse;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import com.tenqube.visual_third.model.api.TransactionRequest;
import com.tenqube.visual_third.repository.AnalysisRepository;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.model.ParsingRule;

public class VisualApi {
    public static final String TAG = VisualApi.class.getSimpleName();
    public static VisualApi mInstance;
    private Context context;
    private VisualApiService visualApiService;
    private PrefManager prefManager;
    private VisualRepository repository;
    private AnalysisRepository analysisRepository;
    private static final int API_KEY = 0;
    private static final int AUTHORIZATION = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VisualApi getInstance(Context context) {
        Class<VisualApi> clazz = VisualApi.class;
        synchronized (VisualApi.class) {
            if (mInstance == null) {
                mInstance = new VisualApi(context.getApplicationContext());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    private VisualApi(Context context) {
        this.context = context;
        this.prefManager = PrefManager.getInstance(context);
        this.repository = VisualRepository.getInstance(context);
        this.analysisRepository = AnalysisRepository.getInstance(context);
    }

    private VisualApiService getApiService() {
        if (this.visualApiService == null) {
            this.visualApiService = (VisualApiService)this.provideRetrofit(this.getUrl()).create(VisualApiService.class);
        }
        return this.visualApiService;
    }

    private String[] getAuthInfo() {
        return new String[]{this.prefManager.loadStringValue("TENQUBE_API_KEY", ""), this.prefManager.loadStringValue("TENQUBE_UID", "")};
    }

    private String[] getSearchAuthInfo() {
        return new String[]{this.prefManager.loadStringValue("TENQUBE_SEARCH_API_KEY", ""), this.prefManager.loadStringValue("TENQUBE_UID", "")};
    }

    private String getUrl() {
        return "https://clip.tenqube.kr/" + this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev") + "/";
    }

    private Retrofit provideRetrofit(String url) {
        return new Retrofit.Builder().baseUrl(url).client(this.provideOkHttpClient()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)new Gson())).build();
    }

    private OkHttpClient provideOkHttpClient() {
        OkHttpClient.Builder okhttpClientBuilder = new OkHttpClient.Builder();
        okhttpClientBuilder.connectTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.readTimeout(5L, TimeUnit.SECONDS);
        okhttpClientBuilder.writeTimeout(5L, TimeUnit.SECONDS);
        return okhttpClientBuilder.build();
    }

    public SignUpResponse signUp(SignUpRequest signUpInfo) {
        try {
            Response response = this.getApiService().signUp(this.getAuthInfo()[0], signUpInfo).execute();
            if (response.isSuccessful()) {
                return (SignUpResponse)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void syncCategory(int version) {
        try {
            String[] authInfo = this.getAuthInfo();
            Call<SyncCategoryResponse> call = this.getApiService().syncCategory(authInfo[0], authInfo[1], version);
            call.enqueue((Callback)new Callback<SyncCategoryResponse>(){

                public void onResponse(Call<SyncCategoryResponse> call, Response<SyncCategoryResponse> response) {
                    SyncCategoryResponse categoryResponse;
                    if (response.isSuccessful() && (categoryResponse = (SyncCategoryResponse)response.body()) != null) {
                        VisualApi.this.prefManager.saveIntValue("TENQUBE_CATEGORY_VERSION", categoryResponse.getVersion());
                        if (!categoryResponse.getCategories().isEmpty()) {
                            VisualApi.this.repository.mergeCategory(categoryResponse.getCategories());
                        }
                    }
                }

                public void onFailure(Call<SyncCategoryResponse> call, Throwable t) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ParsingRule syncParsingRule(int version) {
        try {
            String[] authInfo = this.getAuthInfo();
            Response response = this.getApiService().syncParsingRule(authInfo[0], authInfo[1], version).execute();
            if (response.isSuccessful()) {
                return (ParsingRule)response.body();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public SearchCompanyResponse searchCompany(SearchCompanyRequest searchCompanyRequest) {
        try {
            String[] searchAuthInfo = this.getSearchAuthInfo();
            String searchUrl = this.prefManager.loadStringValue("TENQUBE_SEARCH_URL", "");
            Response response = this.getApiService().searchCompany(searchAuthInfo[0], searchAuthInfo[1], searchUrl, searchCompanyRequest).execute();
            if (response.isSuccessful()) {
                this.repository.updateRetrySearch(searchCompanyRequest.getTransactions(), false);
                return (SearchCompanyResponse)response.body();
            }
            if (response.code() == 499 || response.code() == 500) {
                this.repository.updateRetrySearch(searchCompanyRequest.getTransactions(), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void saveTransactions(TransactionRequest transactionRequest, Callback<Void> callback) {
        String[] authInfo = this.getAuthInfo();
        Call<Void> call = this.getApiService().saveTransactions(authInfo[0], authInfo[1], transactionRequest);
        call.enqueue(callback);
    }

    public void syncTransactions(final OnNetworkResultListener callback) {
        final TransactionRequest transactionRequest = this.repository.loadNotSyncedTransactions();
        if (transactionRequest != null) {
            this.saveTransactions(transactionRequest, new Callback<Void>(){

                public void onResponse(Call<Void> call, Response<Void> response) {
                    if (response.isSuccessful() || response.code() == 400) {
                        VisualApi.this.repository.updateSyncedTransactions(transactionRequest);
                    }
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }

                public void onFailure(Call<Void> call, Throwable t) {
                    if (callback != null) {
                        callback.onResult(true);
                    }
                }
            });
        } else if (callback != null) {
            callback.onResult(true);
        }
    }

    public float getCurrencyRate(String from, String to) {
        try {
            CurrencyResponse currencyResponse;
            String[] authInfo = this.getAuthInfo();
            Response response = this.getApiService().callCurrencyRate(authInfo[0], authInfo[1], from, to).execute();
            if (response.isSuccessful() && (currencyResponse = (CurrencyResponse)response.body()) != null) {
                this.repository.mergeCurrency(from, to, currencyResponse.getRate(), Utils.getStringDateAsYYYYMMddHHmmss(Calendar.getInstance()));
                return currencyResponse.getRate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1.0f;
    }

    public void syncAnalysis(int version) {
        try {
            String[] authInfo = this.getAuthInfo();
            Call<AnalysisResponse> call = this.getApiService().syncAnalysis(authInfo[0], authInfo[1], version);
            call.enqueue((Callback)new Callback<AnalysisResponse>(){

                public void onResponse(Call<AnalysisResponse> call, Response<AnalysisResponse> response) {
                    AnalysisResponse analysisResponse;
                    if (response.isSuccessful() && (analysisResponse = (AnalysisResponse)response.body()) != null) {
                        VisualApi.this.prefManager.saveIntValue("TENQUBE_ANALYSIS_VERSION", analysisResponse.getVersion());
                        if (!Utils.isEmpty(analysisResponse.getContents())) {
                            VisualApi.this.analysisRepository.mergeAnalysis(analysisResponse.getContents());
                        }
                    }
                }

                public void onFailure(Call<AnalysisResponse> call, Throwable t) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

