/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.text.TextUtils;
import com.tenqube.visual_third.analysis.FunctionMap;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Morning;
import com.tenqube.visual_third.model.analysis.Result;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.util.Utils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class AnalysisHelper {
    private static final String KEY_DELIMITER = ";";
    private static final DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private static final DecimalFormat decimalFormatWithDot = new DecimalFormat("###,###.#");

    static HashMap<String, AggregationValue> aggregate(ArrayList<Transaction> transactions, int ... keys) {
        HashMap<String, AggregationValue> results = new HashMap<String, AggregationValue>();
        for (Transaction transaction : transactions) {
            String key = AnalysisHelper.makeKey(transaction, keys);
            AggregationValue aggregation = results.get(key);
            if (aggregation != null) {
                aggregation.setSum(aggregation.getSum() + transaction.getTransaction().getSpentMoney());
                aggregation.setCnt(aggregation.getCnt() + 1);
                aggregation.setAvg();
                aggregation.getTranIds().add(transaction.getTransaction().getId());
            } else {
                ArrayList<Integer> tranIds = new ArrayList<Integer>();
                tranIds.add(transaction.getTransaction().getId());
                aggregation = new AggregationValue(key, transaction.getTransaction().getSpentMoney(), 1, transaction.getTransaction().getSpentMoney(), tranIds);
                aggregation.setTitle(AnalysisHelper.getTitle(transaction, keys.length > 0 ? keys[0] : 0));
            }
            results.put(key, aggregation);
        }
        return results;
    }

    private static String makeKey(Transaction transaction, int ... keys) {
        ArrayList<String> aggregateKey = new ArrayList<String>();
        block8: for (int key : keys) {
            switch (key) {
                case 2: {
                    aggregateKey.add(transaction.getCategory().getLargeCode());
                    continue block8;
                }
                case 1: {
                    aggregateKey.add(Utils.getYMD(transaction.getTransaction().getSpentDate()));
                    continue block8;
                }
                case 3: {
                    aggregateKey.add(transaction.getCategory().getLargeMediumCode());
                    continue block8;
                }
                case 4: {
                    aggregateKey.add("" + transaction.getCard().getChangeType());
                    continue block8;
                }
                case 5: {
                    aggregateKey.add("" + transaction.getTransaction().getFranchise());
                    continue block8;
                }
                case 6: {
                    aggregateKey.add("" + transaction.getTransaction().getKeyword());
                    continue block8;
                }
                default: {
                    aggregateKey.add("");
                }
            }
        }
        return TextUtils.join((CharSequence)KEY_DELIMITER, aggregateKey);
    }

    private static String getTitle(Transaction transaction, int key) {
        String title;
        switch (key) {
            case 6: {
                title = transaction.getTransaction().getKeyword();
                break;
            }
            case 2: {
                title = transaction.getCategory().getLarge();
                break;
            }
            case 3: {
                title = transaction.getCategory().getMedium();
                break;
            }
            case 4: {
                title = transaction.getCategory().getMedium();
                break;
            }
            default: {
                title = "";
            }
        }
        return title;
    }

    private static String makeKeyTitle(int ... keys) {
        ArrayList<String> aggregateKey = new ArrayList<String>();
        block8: for (int key : keys) {
            switch (key) {
                case 1: {
                    aggregateKey.add("\uc6d4\ubcc4");
                    continue block8;
                }
                case 2: {
                    aggregateKey.add("\ub300\ubd84\ub958\ubcc4");
                    continue block8;
                }
                case 3: {
                    aggregateKey.add("\uc911\ubd84\ub958\ubcc4");
                    continue block8;
                }
                case 4: {
                    aggregateKey.add("\uce74\ub4dc\ud0c0\uc785\ubcc4");
                    continue block8;
                }
                case 5: {
                    aggregateKey.add("\ud68c\uc0ac\ubcc4");
                    continue block8;
                }
                case 6: {
                    aggregateKey.add("\ud0a4\uc6cc\ub4dc\ubcc4");
                    continue block8;
                }
                default: {
                    aggregateKey.add("");
                }
            }
        }
        return TextUtils.join((CharSequence)KEY_DELIMITER, aggregateKey);
    }

    static int getMonth(int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1 * before);
        return calendar.get(2) + 1;
    }

    static ArrayList<Transaction> filterTransactions(ArrayList<Transaction> transactions, int before) {
        ArrayList<Transaction> filteredTransaction = new ArrayList<Transaction>();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1 * before);
        String monthStr = Utils.getYM(calendar);
        for (Transaction transaction : transactions) {
            if (!monthStr.equals(Utils.getYM(transaction.getTransaction().getSpentDate()))) continue;
            filteredTransaction.add(transaction);
        }
        return filteredTransaction;
    }

    static double getSamePeriodSum(ArrayList<Transaction> transactions, int before) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1 * before);
        double sum = 0.0;
        for (Transaction transaction : transactions) {
            if (!Utils.compareDate(transaction.getTransaction().getSpentDate(), Utils.getYMD(calendar))) continue;
            sum += transaction.getTransaction().getSpentMoney();
        }
        return sum;
    }

    static ArrayList<Transaction> filterTransactionsDaily(ArrayList<Transaction> transactions, int before) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        ArrayList<String> dateRanges = Utils.getDailyDateRanges(before);
        for (Transaction transaction : transactions) {
            if (!Utils.compareDate(dateRanges.get(0), transaction.getTransaction().getSpentDate()) || !Utils.compareDate(transaction.getTransaction().getSpentDate(), dateRanges.get(1))) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static ArrayList<Transaction> filterTransactionsWeekly(ArrayList<Transaction> transactions, int before) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        ArrayList<String> dateRanges = Utils.getWeeklyDateRanges(before);
        for (Transaction transaction : transactions) {
            if (!Utils.compareDate(dateRanges.get(0), transaction.getTransaction().getSpentDate()) || !Utils.compareDate(transaction.getTransaction().getSpentDate(), dateRanges.get(1))) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static ArrayList<Transaction> filterTransactionsMcode(ArrayList<Transaction> transactions, int ... mcodes) {
        ArrayList<Transaction> filteredTransactions = new ArrayList<Transaction>();
        for (Transaction transaction : transactions) {
            boolean isMatched = true;
            for (int mcode : mcodes) {
                if (String.valueOf(mcode).equals(transaction.getCategory().getLargeMediumCode())) continue;
                isMatched = false;
                break;
            }
            if (!isMatched) continue;
            filteredTransactions.add(transaction);
        }
        return filteredTransactions;
    }

    static Morning getMorningSum(ArrayList<Transaction> transactions, int mcode) {
        int fromHour = 7;
        int toHour = 10;
        double sum = 0.0;
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Transaction transaction : transactions) {
            Calendar calendar;
            int hour;
            if (!String.valueOf(mcode).equals(transaction.getCategory().getLargeMediumCode()) || fromHour > (hour = (calendar = Utils.toCalendar(transaction.getTransaction().getSpentDate())).get(11)) || hour >= toHour) continue;
            sum += transaction.getTransaction().getSpentMoney();
            ids.add(transaction.getTransaction().getId());
        }
        return new Morning(sum, ids);
    }

    static Transaction getMaxKeyword(ArrayList<Transaction> transactions) {
        Transaction maxTransaction = null;
        for (Transaction transaction : transactions) {
            if (maxTransaction == null || maxTransaction.getTransaction().getSpentMoney() < transaction.getTransaction().getSpentMoney()) {
                maxTransaction = transaction;
                continue;
            }
            if (maxTransaction.getTransaction().getSpentMoney() != transaction.getTransaction().getSpentMoney()) continue;
            if (Utils.compareDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate())) {
                maxTransaction = transaction;
                continue;
            }
            if (!Utils.equalsDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate()) || maxTransaction.getTransaction().getId() >= transaction.getTransaction().getId()) continue;
            maxTransaction = transaction;
        }
        return maxTransaction;
    }

    static Transaction getMaxSpentDate(ArrayList<Transaction> transactions) {
        Transaction maxTransaction = null;
        for (Transaction transaction : transactions) {
            if (maxTransaction == null || Utils.compareDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate())) {
                maxTransaction = transaction;
                continue;
            }
            if (!Utils.compareDatetime(maxTransaction.getTransaction().getSpentDate(), transaction.getTransaction().getSpentDate()) || maxTransaction.getTransaction().getId() >= transaction.getTransaction().getId()) continue;
            maxTransaction = transaction;
        }
        return maxTransaction;
    }

    public static boolean isSatisfied(Condition condition) {
        try {
            if (condition == null) {
                return false;
            }
            String[] values = AnalysisHelper.getValues(condition.getFuncKeys().split(","));
            if (values == null || values.length == 0 || TextUtils.isEmpty((CharSequence)values[0])) {
                return false;
            }
            switch (condition.getFuncType()) {
                case "=": {
                    return Double.parseDouble(condition.getStandard()) == Double.parseDouble(values[0]);
                }
                case "<": {
                    return Double.parseDouble(condition.getStandard()) < Double.parseDouble(values[0]);
                }
                case ">": {
                    return Double.parseDouble(condition.getStandard()) > Double.parseDouble(values[0]);
                }
                case ">=": {
                    return Double.parseDouble(condition.getStandard()) >= Double.parseDouble(values[0]);
                }
                case "<=": {
                    return Double.parseDouble(condition.getStandard()) <= Double.parseDouble(values[0]);
                }
                case "!=": {
                    return Double.parseDouble(condition.getStandard()) != Double.parseDouble(values[0]);
                }
                case "function*<": {
                    return Double.parseDouble(values[0]) * Double.parseDouble(condition.getStandard()) < Double.parseDouble(values[1]);
                }
                case "function*>": {
                    return Double.parseDouble(values[0]) * Double.parseDouble(condition.getStandard()) > Double.parseDouble(values[1]);
                }
                case "date=": {
                    return Utils.equalsDate(condition.getStandard(), values[0]);
                }
                case "date<": {
                    return Utils.ltDate(condition.getStandard(), values[0]);
                }
                case "date>": {
                    return Utils.gtDate(condition.getStandard(), values[0]);
                }
                case "date<=": {
                    return Utils.compareDate(condition.getStandard(), values[0]);
                }
                case "date>=": {
                    return Utils.compareDate(values[0], condition.getStandard());
                }
                case "odd": {
                    return Utils.isOddDay();
                }
                case "even": {
                    return Utils.isEvenDay();
                }
                case "True": {
                    return true;
                }
                case "isEmpty": {
                    if ("0".equals(condition.getStandard())) {
                        return !TextUtils.isEmpty((CharSequence)values[0]);
                    }
                    return TextUtils.isEmpty((CharSequence)values[0]);
                }
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static String[] getValues(String[] keys) {
        String[] funcResults = new String[keys.length];
        int i = 0;
        for (String key : keys) {
            String value;
            funcResults[i] = value = AnalysisHelper.getFuncValue(Integer.parseInt(key));
            ++i;
        }
        return funcResults;
    }

    static String getContent(String content, String funcKey) {
        try {
            if (TextUtils.isEmpty((CharSequence)funcKey) || "none".equals(funcKey)) {
                return content;
            }
            String[] funcKeys = funcKey.split(",");
            Object[] values = new String[funcKey.length()];
            for (int i = 0; i < funcKeys.length; ++i) {
                Result result = (Result)FunctionMap.values.get(Integer.parseInt(funcKeys[i]));
                if (result == null) {
                    throw new Exception();
                }
                values[i] = result.getDisplayValue();
            }
            return String.format(content, values);
        }
        catch (Exception e) {
            e.printStackTrace();
            return content;
        }
    }

    static String getValue(String image) {
        try {
            int key = Integer.parseInt(image);
            String imagePath = AnalysisHelper.getFuncValue(key);
            if (!TextUtils.isEmpty((CharSequence)imagePath)) {
                image = imagePath;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return image;
    }

    static ArrayList<Integer> getTranIds(JoinedContent content) {
        ArrayList<Integer> tranIds = new ArrayList<Integer>();
        try {
            String[] rawKeys;
            for (String rawKey : rawKeys = content.getContent().getRawKeys().split(",")) {
                ArrayList temIds = (ArrayList)FunctionMap.tranIds.get(Integer.parseInt(rawKey));
                if (Utils.isEmpty(temIds)) continue;
                tranIds.addAll(temIds);
            }
            return tranIds;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tranIds;
        }
    }

    public static String getLv0Currency(double amount) {
        if (amount < 1000.0) {
            return decimalFormat.format(amount) + "\uc6d0";
        }
        return decimalFormatWithDot.format(amount / 10000.0) + "\ub9cc\uc6d0";
    }

    public static String getNumber(double amount) {
        return decimalFormat.format(amount) + "\uc6d0";
    }

    public static String getPercent(double value) {
        if (value == 0.0) {
            return "0.0 %";
        }
        return decimalFormatWithDot.format(value) + "%";
    }

    public static String getCnt(double value, String unit) {
        return decimalFormatWithDot.format(value) + unit;
    }

    public static String getNumberFirst(double value) {
        return decimalFormatWithDot.format(value);
    }

    public static String[] getAlcoholType(int cnt) {
        if (cnt == 0) {
            return new String[]{"\ube44\uc74c\uc8fc", "lv0_alcohol_type_no_alcohol"};
        }
        if (cnt > 0 && cnt <= 2) {
            return new String[]{"\uac74\uac15 \uc911\uc2dc\ud615", "lv0_alcohol_type_healthy"};
        }
        if (cnt > 2 && cnt <= 5) {
            return new String[]{"\uc2a4\ud2b8\ub808\uc2a4 \ud574\uc18c", "lv0_alcohol_type_stress_down"};
        }
        if (cnt > 5 && cnt <= 8) {
            return new String[]{"\uc560\uc8fc\uac00\ud615", "lv0_alcohol_type_lover"};
        }
        if (cnt > 8) {
            return new String[]{"\ubc25\ubcf4\ub2e4 \uc220", "lv0_alcohol_type_prefer_al"};
        }
        return new String[]{"\ube44\uc74c\uc8fc", "lv0_alcohol_type_no_alcohol"};
    }

    public static String[] getCoffeeCountry(double weekAvg) {
        if (23.0 < weekAvg) {
            return new String[]{"\ub178\ub974\uc6e8\uc774", "25\uc794/1\uc8fc\uc77c"};
        }
        if (20.0 < weekAvg && weekAvg <= 23.0) {
            return new String[]{"\uc2a4\uc704\uc2a4", "22\uc794/1\uc8fc\uc77c"};
        }
        if (17.0 < weekAvg & weekAvg <= 20.0) {
            return new String[]{"\uce90\ub098\ub2e4", "19\uc794/1\uc8fc\uc77c"};
        }
        if (14.0 < weekAvg && weekAvg <= 17.0) {
            return new String[]{"\ube0c\ub77c\uc9c8", "16\uc794/1\uc8fc\uc77c"};
        }
        if (11.8 < weekAvg && weekAvg <= 14.0) {
            return new String[]{"\ubbf8\uad6d", "13\uc794/1\uc8fc\uc77c"};
        }
        if (8.5 < weekAvg && weekAvg <= 11.8) {
            return new String[]{"\uc77c\ubcf8", "11\uc794/1\uc8fc\uc77c"};
        }
        if (5.5 < weekAvg && weekAvg <= 8.5) {
            return new String[]{"\ud55c\uad6d", "6\uc794/1\uc8fc\uc77c"};
        }
        if (3.0 < weekAvg && weekAvg <= 5.5) {
            return new String[]{"\ub7ec\uc2dc\uc544", "5\uc794/1\uc8fc\uc77c"};
        }
        if (2.2 < weekAvg && weekAvg <= 3.0) {
            return new String[]{"\ud0dc\uad6d", "3\uc794/1\uc8fc\uc77c"};
        }
        if (0.97 < weekAvg && weekAvg <= 2.2) {
            return new String[]{"\uc774\uc9d1\ud2b8", "2\uc794/1\uc8fc\uc77c"};
        }
        return new String[]{"\uc778\ub3c4", "1\uc794 \uc774\ud558/1\uc8fc\uc77c"};
    }

    public static double getAggregate(HashMap<String, AggregationValue> map, String key, int agType) {
        double result = 0.0;
        try {
            if (map != null && map.get(key) != null) {
                switch (agType) {
                    case 0: {
                        return map.get(key).getSum();
                    }
                    case 1: {
                        return map.get(key).getCnt();
                    }
                    case 2: {
                        return map.get(key).getAvg();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ArrayList<Integer> getAggregatedTranIds(HashMap<String, AggregationValue> map, String key) {
        try {
            if (map != null && map.get(key) != null) {
                return map.get(key).getTranIds();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ArrayList<Integer>();
    }

    public static double getPercentValue(double first, double divider) {
        if (divider == 0.0) {
            return 0.0;
        }
        return (first - divider) * 100.0 / divider;
    }

    public static void desc(ArrayList<AggregationValue> values) {
        Collections.sort(values, new Comparator<AggregationValue>(){

            @Override
            public int compare(AggregationValue f1, AggregationValue f2) {
                return f1.getSum() > f2.getSum() ? -1 : 1;
            }
        });
    }

    public static void descAnalysis(ArrayList<Analysis> values) {
        Collections.sort(values, new Comparator<Analysis>(){

            @Override
            public int compare(Analysis f1, Analysis f2) {
                return f1.getCategoryPriority() > f2.getCategoryPriority() ? -1 : 1;
            }
        });
    }

    public static void ascAnalysis(ArrayList<Analysis> values) {
        Collections.sort(values, new Comparator<Analysis>(){

            @Override
            public int compare(Analysis f1, Analysis f2) {
                return f1.getCategoryPriority() > f2.getCategoryPriority() ? 1 : -1;
            }
        });
    }

    public static String getMidImage(String lcode) {
        try {
            String[] images = AnalysisHelper.getMidImages(Integer.parseInt(lcode));
            return images[Utils.getRandomNumber(images.length)];
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String[] getMidImages(int lcode) {
        switch (lcode) {
            case 22: {
                return new String[]{"lv0_mid_food_boonsik", "lv0_mid_food_buffet", "lv0_mid_food_oriental_vietnamese", "lv0_mid_food_oriental_indian", "lv0_mid_food_oriental", "lv0_mid_food_late_night", "lv0_mid_food_western", "lv0_mid_food_western_pizza", "lv0_mid_food_dining_place", "lv0_mid_food_japanese", "lv0_mid_food_chinese", "lv0_mid_chicken", "lv0_mid_food_fam_re", "lv0_mid_food_fastfood", "lv0_mid_food_korean", "lv0_mid_food_korean_1", "lv0_mid_food_korean_dosirak", "lv0_mid_food_korean_seafood"};
            }
            case 24: {
                return new String[]{"lv0_mid_cafe_donut", "lv0_mid_cafe_dessert", "lv0_mid_cafe_bakery", "lv0_mid_cafe_sandwich", "lv0_mid_cafe_tea", "lv0_mid_cafe_tea_bingsu", "lv0_mid_cafe_coffee"};
            }
            case 26: {
                return new String[]{"lv0_mid_alcohol_soolzip", "lv0_mid_alcohol_soolzip_beer", "lv0_mid_alcohol_cocktail1", "lv0_mid_alcohol_cocktail2", "lv0_mid_alcohol_hof", "lv0_mid_alcohol_smallbeer", "lv0_mid_alcohol_wine", "lv0_mid_alcohol_entertainment"};
            }
            case 32: {
                return new String[]{"lv0_mid_mart_furniture", "lv0_mid_mart_furniture_wood", "lv0_mid_mart_grocery", "lv0_mid_mart_pets", "lv0_mid_mart_kids_1", "lv0_mid_mart_kids_2", "lv0_mid_mart_dailyitems", "lv0_mid_mart_housework", "lv0_mid_mart_conveni"};
            }
            case 34: {
                return new String[]{"lv0_mid_online_internetshop1", "lv0_mid_online_internetshop2", "lv0_mid_online_homeshop", "lv0_mid_online_cardpoint"};
            }
            case 36: {
                return new String[]{"lv0_mid_shopping_sportbrand", "lv0_mid_shopping_outlet", "lv0_mid_shopping_fashion", "lv0_mid_shopping_miscel"};
            }
            case 42: {
                return new String[]{"lv0_mid_finance_capital", "lv0_mid_finance_insurance", "lv0_mid_finance_tax"};
            }
            case 44: {
                return new String[]{"lv0_mid_healthcare_healthproduct", "lv0_mid_healthcare_recovery", "lv0_mid_healthcare_pharmacy", "lv0_mid_healthcare_clinic", "lv0_mid_healthcare_dentist", "lv0_mid_healthcare_herbalclinic"};
            }
            case 46: {
                return new String[]{"lv0_mid_beauty_nail", "lv0_mid_beauty_skin", "lv0_mid_beauty_makeup", "lv0_mid_beauty_makeup_drugstore"};
            }
            case 52: {
                return new String[]{"lv0_mid_livings_utility", "lv0_mid_livings_realtor", "lv0_mid_livings_moving", "lv0_mid_livings_telecom", "lv0_mid_livings_telecom_2", "lv0_mid_livings_bills"};
            }
            case 54: {
                return new String[]{"lv0_mid_education_school", "lv0_mid_education_edubook", "lv0_mid_education_facility", "lv0_mid_education_academy"};
            }
            case 56: {
                return new String[]{"lv0_mid_culture_books", "lv0_mid_books", "lv0_mid_culture_movies", "lv0_mid_culture_movies_2", "lv0_mid_culture_museum", "lv0_mid_culture_concert", "lv0_mid_culture_hobby"};
            }
            case 62: {
                return new String[]{"lv0_mid_transportation_masstransit", "lv0_mid_transportation_car", "lv0_mid_transportation_gas", "lv0_mid_transportation_taxi", "lv0_mid_transportation_airline"};
            }
            case 64: {
                return new String[]{"lv0_mid_leports_leisure", "lv0_mid_leports_martial", "lv0_mid_leports_fitness_yoga", "lv0_mid_leports_fitness_training"};
            }
            case 66: {
                return new String[]{"lv0_mid_travel_sightseeing", "lv0_mid_travel_themepark", "lv0_mid_travel_travel"};
            }
            case 82: {
                return new String[]{"lv0_family_event_else"};
            }
        }
        return new String[]{"lv0_uncate_else"};
    }

    public static double getFuncAmount(int key) {
        Result result = (Result)FunctionMap.values.get(key);
        if (result == null) {
            return 0.0;
        }
        return result.getAmount();
    }

    public static String getFuncValue(int key) {
        Result result = (Result)FunctionMap.values.get(key);
        if (result == null) {
            return "";
        }
        return result.getValue();
    }

    public static ArrayList<Integer> getTranIds(ArrayList<Transaction> transactions) {
        ArrayList<Integer> tranIds = new ArrayList<Integer>();
        for (Transaction transaction : transactions) {
            tranIds.add(transaction.getTransaction().getId());
        }
        return tranIds;
    }
}

