package com.tenqube.visual_third.db;

import android.text.TextUtils;

import com.tenqube.visual_third.model.js.TransactionByIdsRequest;
import com.tenqube.visual_third.model.js.TransactionRequest;
import com.tenqube.visual_third.util.Utils;

import static com.tenqube.visual_third.Constants.FROM;
import static com.tenqube.visual_third.Constants.TO;

public class QueryGenerator {

    public static String applyAllTran(String keyword) {
        return  " SELECT * " +
                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME +
                " WHERE " + ReaderContract.TransactionsTable.COLUMN_IS_UPDATE_ALL + " = 1" + " AND " +
                            ReaderContract.TransactionsTable.COLUMN_KEYWORD + " = '" + keyword + "'" +
                " LIMIT 1";

    }

    public static String tranId(String identifier) {
        String whereCondition = ReaderContract.TransactionsTable.COLUMN_IDENTIFIER + "=" + identifier;
        return  " SELECT  " + ReaderContract.TransactionsTable.COLUMN_TRAN_ID +
                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME +
                " WHERE " + whereCondition;

    }


    public static String transaction() {
        return  " SELECT * " +
                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME;

    }

    public static String failedSearchTransaction() {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_SHOULD_RETRY_SEARCH  + "= 1"  +
                " AND " + ReaderContract.TransactionsTable.COLUMN_IS_USER_UPDATE + " = 0";
//        +
//                " AND " + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= 0" +
//                " AND " + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_IS_EXCEPT + "= 0";

        return  " SELECT * " +
                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                " JOIN " + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                " JOIN " + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                " JOIN " + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                " WHERE " + whereCondition;
    }

    public static String joinedTransaction(TransactionByIdsRequest transactionRequest) {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_TRAN_ID  + " IN (" + TextUtils.join(",", transactionRequest.getTranIds()) + ")";
//        +
//                " AND " + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= 0" +
//                " AND " + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_IS_EXCEPT + "= 0";

        return  " SELECT  * " +

                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                " JOIN " + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                " JOIN " + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                " JOIN " + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                " WHERE " + whereCondition;
    }

    public static String joinedTransaction(TransactionRequest transactionRequest) {

        String[] dates = Utils.getDateRange(transactionRequest.getYear(), transactionRequest.getMonth(), transactionRequest.getBefore());
        String whereCondition = ReaderContract.TransactionsTable.COLUMN_SPENT_DATE  + ">= " + dates[FROM] + " AND " + ReaderContract.TransactionsTable.COLUMN_SPENT_DATE + " < " + dates[TO];
//        +
//                " AND " + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_IS_EXCEPT + "= 0" +
//                " AND " + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_IS_EXCEPT + "= 0";

        return  " SELECT  * " +

                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                " JOIN " + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                " JOIN " + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                " JOIN " + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                " WHERE " + whereCondition;
    }

    public static String joinedTransaction(int tranId) {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_TRAN_ID  + " = " + tranId;

        return  " SELECT  * " +

                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                " JOIN " + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                " JOIN " + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                " JOIN " + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                " WHERE " + whereCondition;
    }

    public static String notSyncedTransactions() {

        String whereCondition = ReaderContract.TransactionsTable.COLUMN_IS_SYNCED  + "= 0 AND " +
                ReaderContract.TransactionsTable.COLUMN_COMPANY_ID + " != 0 ";

        return  " SELECT * " +
                " FROM " + ReaderContract.TransactionsTable.TABLE_NAME + ReaderContract.TransactionsTable.AS_ALIAS +

                " JOIN " + ReaderContract.CardTable.TABLE_NAME + ReaderContract.CardTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CARD_ID + "=" + ReaderContract.CardTable.ALIAS + ReaderContract.CardTable.COLUMN_CARD_ID +

                " JOIN " + ReaderContract.UserCategoryTable.TABLE_NAME + ReaderContract.UserCategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_USER_CATEGORY_ID + "=" + ReaderContract.UserCategoryTable.ALIAS + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +

                " JOIN " + ReaderContract.CategoryTable.TABLE_NAME + ReaderContract.CategoryTable.AS_ALIAS +
                " ON " + ReaderContract.TransactionsTable.ALIAS + ReaderContract.TransactionsTable.COLUMN_CATEGORY_CODE + "=" + ReaderContract.CategoryTable.ALIAS + ReaderContract.CategoryTable.COLUMN_CODE +

                " WHERE " + whereCondition +
                " LIMIT " + " 30 ";
    }

    public static String card() {
        return  " SELECT * " +
                " FROM " + ReaderContract.CardTable.TABLE_NAME;
    }

    public static String cardId(String cardName, int cardType, int cardSubType) {
        String whereCondition =
                ReaderContract.CardTable.COLUMN_CARD_NAME + " = '" + cardName + "' " + " AND " +
                ReaderContract.CardTable.COLUMN_CARD_TYPE + " = " + cardType + " AND " +
                ReaderContract.CardTable.COLUMN_CARD_SUB_TYPE + " = " + cardSubType;

        return  " SELECT " + ReaderContract.CardTable.COLUMN_CARD_ID +
                " FROM " + ReaderContract.CardTable.TABLE_NAME +
                " WHERE " + whereCondition;
    }

    public static String category() {

//        String whereCondition = isWithdraw ? ReaderContract.CategoryTable.COLUMN_CODE + " < 900000 "
//                : ReaderContract.CategoryTable.COLUMN_CODE + " > 900000 ";

        return  " SELECT * " +
                " FROM " + ReaderContract.CategoryTable.TABLE_NAME;

    }

    public static String categoryByMedium() {

//        String whereCondition = isWithdraw ? ReaderContract.CategoryTable.COLUMN_CODE + " < 900000 "
//                : ReaderContract.CategoryTable.COLUMN_CODE + " > 900000 ";

        return  " SELECT * " +
                " FROM " + ReaderContract.CategoryTable.TABLE_NAME +
                " GROUP BY " + " substr( " + ReaderContract.CategoryTable.COLUMN_CODE+", 1, 4)" ;

    }

    public static String category(String categoryCode) {

        String whereCondition = ReaderContract.CategoryTable.COLUMN_CODE + "=" + categoryCode;

        return  " SELECT * " +
                " FROM " + ReaderContract.CategoryTable.TABLE_NAME +
                " WHERE " + whereCondition;

    }

    public static String userCategory() {
        return  " SELECT * " +
                " FROM " + ReaderContract.UserCategoryTable.TABLE_NAME;
    }

    public static String userCategory(String repCode) {
        String whereCondition = ReaderContract.UserCategoryTable.COLUMN_CODE + "=" + repCode;

        return  " SELECT  " + ReaderContract.UserCategoryTable.COLUMN_USER_CATE_ID +
                " FROM " + ReaderContract.UserCategoryTable.TABLE_NAME +
                " WHERE " + whereCondition;
    }

    public static String contents() {

        return  " SELECT * " +
                " FROM " + ReaderContract.ContentTable.TABLE_NAME;

    }

    public static String conditions() {

        return  " SELECT * " +
                " FROM " + ReaderContract.ConditionTable.TABLE_NAME;
    }

    public static String currency(String from, String to) {
        String whereCondition =  ReaderContract.CurrencyTable.COLUMN_FROM + "='" + from + "'" +
                " AND " + ReaderContract.CurrencyTable.COLUMN_TO + "='" + to + "'";
        return
                " SELECT " + "*" +
                " FROM " + ReaderContract.CurrencyTable.TABLE_NAME +
                " WHERE " + whereCondition;
    }




}
