/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.parser.loader;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.parser.loader.BaseLoader;
import com.tenqube.visual_third.util.Mapper;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import tenqube.parser.BulkSmsAdapter;
import tenqube.parser.OnNetworkResultListener;
import tenqube.parser.constants.Constants;
import tenqube.parser.model.SMS;
import tenqube.parser.model.Transaction;

public class BulkLoader
extends BaseLoader
implements BulkSmsAdapter {
    private Cursor mCursor;
    private final Handler mHandler;
    private final OnSmsLoadFinished onSmsLoadFinished;

    public BulkLoader(Context context, Handler handler, OnSmsLoadFinished onSmsLoadFinished) {
        super(context);
        this.mHandler = handler;
        this.onSmsLoadFinished = onSmsLoadFinished;
    }

    public void doParsing() {
        this.initCursor();
        this.syncParsingRule();
        this.parserService.parseBulk((BulkSmsAdapter)this);
    }

    private void initCursor() {
        try {
            Uri uri = Uri.parse((String)"content://sms/inbox");
            this.mCursor = this.mContext.getContentResolver().query(uri, null, this.getWhere(), null, "date asc");
            if (this.mCursor != null) {
                this.mCursor.moveToFirst();
            }
        }
        catch (Exception e) {
            this.onError(1);
        }
    }

    private String getWhere() {
        Calendar calendar = Calendar.getInstance();
        long time = this.prefManager.loadLongValue("TENQUBE_SIGN_UP_TIME", 0L);
        if (time != 0L) {
            calendar.setTimeInMillis(time);
        }
        calendar.add(2, -6);
        return "date > " + calendar.getTimeInMillis() + " and date <= " + time;
    }

    public int getSmsCount() {
        return this.mCursor == null ? 0 : this.mCursor.getCount();
    }

    public SMS getSmsAt(int n) {
        return this.getSMS();
    }

    private SMS getSMS() {
        SMS sms = null;
        if (this.mCursor != null) {
            sms = new SMS(this.mCursor.getInt(this.mCursor.getColumnIndex("_id")), this.mCursor.getString(this.mCursor.getColumnIndex("body")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), this.mCursor.getString(this.mCursor.getColumnIndex("address")), Utils.getConvertedDate(this.mCursor.getLong(this.mCursor.getColumnIndex("date"))), Constants.SMSType.SMS.ordinal());
            this.mCursor.moveToNext();
        }
        return sms;
    }

    public void onProgress(int now, int total) {
        int percent = now * 100 / total + 1;
        Bundle data = new Bundle();
        data.putInt("percent", percent);
        data.putInt("now", now);
        data.putInt("total", total);
        this.sendHandlerMsg(data, 11, percent);
    }

    public void sendToServerTransactions(ArrayList<Transaction> transactions, OnNetworkResultListener callback) {
        this.setCurrency(transactions);
        this.repository.mergeTransactions(transactions);
        SearchCompanyResponse response = this.api.searchCompany(new SearchCompanyRequest(Mapper.toSearchTransaction(transactions)));
        if (response != null) {
            this.repository.updateTransactions(response);
        }
        this.api.syncTransactions(callback);
    }

    public void onCompleted() {
        this.sendHandlerMsg(null, 10, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(false);
        }
    }

    public void onError(int resultCode) {
        this.sendHandlerMsg(null, 10, 0);
        if (this.mCursor != null) {
            this.mCursor.close();
        }
        if (this.onSmsLoadFinished != null) {
            this.onSmsLoadFinished.onFinished(true);
        }
    }

    private void sendHandlerMsg(Bundle data, int what, int arg1) {
        if (this.mHandler != null) {
            Message hMsg = this.mHandler.obtainMessage();
            if (data != null) {
                hMsg.setData(data);
            }
            hMsg.what = what;
            hMsg.arg1 = arg1;
            this.mHandler.sendMessage(hMsg);
        }
    }

    public static interface OnSmsLoadFinished {
        public void onFinished(boolean var1);
    }
}

