/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.api;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import tenqube.parser.constants.Constants;

public class TransactionRequest
implements Serializable {
    private ArrayList<Transaction> transactions;

    public ArrayList<Transaction> getTransactions() {
        return this.transactions;
    }

    public TransactionRequest(ArrayList<Transaction> transactions) {
        this.transactions = transactions;
    }

    public static class Transaction
    implements Serializable {
        private String identifier;
        private String cardName;
        private String cardNum;
        private int cardType;
        private int cardSubType;
        private double spentMoney;
        private double oriSpentMoney;
        private String spentDate;
        private String finishDate;
        private String oriKeyword;
        private String searchKeyword;
        private int installmentCount;
        private int dwType;
        private String currency;
        private double balance;
        private String sender;
        private String fullSms;
        private String smsDate;
        private int smsType;
        private int isOffset;
        private int isDuplicate;
        private String memo;
        private double spentLatitude;
        private double spentLongitude;
        private int categoryCode;
        private int companyId;
        private String classCode;
        private int regId;

        public String toString() {
            return "Transaction{identifier='" + this.identifier + '\'' + ", cardName='" + this.cardName + '\'' + ", cardNum='" + this.cardNum + '\'' + ", cardType=" + this.cardType + ", cardSubType=" + this.cardSubType + ", spentMoney=" + this.spentMoney + ", oriSpentMoney=" + this.oriSpentMoney + ", spentDate='" + this.spentDate + '\'' + ", finishDate='" + this.finishDate + '\'' + ", oriKeyword='" + this.oriKeyword + '\'' + ", searchKeyword='" + this.searchKeyword + '\'' + ", installmentCount=" + this.installmentCount + ", dwType=" + this.dwType + ", currency='" + this.currency + '\'' + ", balance=" + this.balance + ", sender='" + this.sender + '\'' + ", fullSms='" + this.fullSms + '\'' + ", smsDate='" + this.smsDate + '\'' + ", smsType=" + this.smsType + ", isOffset=" + this.isOffset + ", isDuplicate=" + this.isDuplicate + ", memo='" + this.memo + '\'' + ", spentLatitude=" + this.spentLatitude + ", spentLongitude=" + this.spentLongitude + ", categoryCode=" + this.categoryCode + ", companyId=" + this.companyId + ", classCode='" + this.classCode + '\'' + ", regId=" + this.regId + '}';
        }

        public Transaction(JoinedTransaction transaction) throws ParameterException {
            if (transaction == null || transaction.getCard() == null || transaction.getTransaction() == null || transaction.getCategory() == null || transaction.getUserCategory() == null) {
                throw new ParameterException("transaction is null");
            }
            this.setIdentifier(transaction.getTransaction().getIdentifier() + "");
            this.setCardName(transaction.getCard().getName());
            this.setCardType(transaction.getCard().getType());
            this.setCardSubType(transaction.getCard().getSubType());
            this.setSpentMoney(transaction.getTransaction().getSpentMoney());
            this.setOriSpentMoney(transaction.getTransaction().getOriSpentMoney());
            this.setSpentDate(transaction.getTransaction().getSpentDate());
            this.setFinishDate(transaction.getTransaction().getFinishDate());
            this.setOriKeyword(transaction.getTransaction().getKeyword());
            this.setSearchKeyword(transaction.getTransaction().getSearchKeyword());
            this.setInstallmentCount(transaction.getTransaction().getInstallmentCnt());
            this.setDwType(transaction.getTransaction().getDwType());
            this.setCurrency(transaction.getTransaction().getCurrency());
            this.setBalance(transaction.getCard().getBalance());
            this.setSender(transaction.getTransaction().getSender());
            this.setFullSms(transaction.getTransaction().getFullSms());
            this.setSmsDate(transaction.getTransaction().getSmsDate());
            this.setSmsType(transaction.getTransaction().getSmsType());
            this.setIsOffset(transaction.getTransaction().isOffset() ? 1 : 0);
            this.setMemo(transaction.getTransaction().getMemo());
            this.setSpentLatitude(transaction.getTransaction().getLat());
            this.setSpentLongitude(transaction.getTransaction().getLng());
            this.setCategoryCode(transaction.getTransaction().getCategoryCode());
            this.setCompanyId(transaction.getTransaction().getCompanyId());
            this.setClassCode(transaction.getTransaction().getClassCode());
            this.setRegId(transaction.getTransaction().getRegId());
        }

        public String getIdentifier() {
            return this.identifier;
        }

        private void setIdentifier(String identifier) throws ParameterException {
            Validator.isStr(identifier, 50);
            this.identifier = identifier;
        }

        private void setCardName(String cardName) throws ParameterException {
            Validator.isStr(cardName, 50);
            this.cardName = cardName;
        }

        private void setCardNum(String cardNum) {
            this.cardNum = cardNum;
        }

        private void setCardType(int cardType) throws ParameterException {
            Validator.in(cardType, Constants.CardType.CHECK.ordinal(), Constants.CardType.CARD.ordinal(), Constants.CardType.BANK_ACCOUNT.ordinal(), Constants.CardType.CASH.ordinal());
            this.cardType = cardType;
        }

        private void setCardSubType(int cardSubType) throws ParameterException {
            Validator.in(cardSubType, Constants.CardSubType.NORMAL.ordinal(), Constants.CardSubType.CORPORATION.ordinal(), Constants.CardSubType.FAMILY.ordinal());
            this.cardSubType = cardSubType;
        }

        private void setSpentMoney(double spentMoney) {
            this.spentMoney = spentMoney;
        }

        private void setOriSpentMoney(double oriSpentMoney) {
            if (oriSpentMoney == 0.0) {
                oriSpentMoney = this.spentMoney;
            }
            this.oriSpentMoney = oriSpentMoney;
        }

        private void setSpentDate(String spentDate) throws ParameterException {
            Validator.isDate(spentDate);
            this.spentDate = spentDate;
        }

        private void setFinishDate(String finishDate) {
            try {
                Validator.isDate(finishDate);
            }
            catch (ParameterException e) {
                finishDate = this.spentDate;
            }
            this.finishDate = finishDate;
        }

        private void setOriKeyword(String oriKeyword) throws ParameterException {
            Validator.isStr(oriKeyword, 50);
            this.oriKeyword = oriKeyword;
        }

        private void setSearchKeyword(String searchKeyword) throws ParameterException {
            Validator.isStr(this.oriKeyword, 50);
            this.searchKeyword = searchKeyword;
        }

        private void setInstallmentCount(int installmentCount) throws ParameterException {
            Validator.gt(installmentCount, 0);
            Validator.lt(installmentCount, 25);
            this.installmentCount = installmentCount == 0 ? 1 : installmentCount;
        }

        private void setDwType(int dwType) throws ParameterException {
            Validator.in(dwType, Constants.DWType.DEPOSIT.ordinal(), Constants.DWType.WITHDRAW.ordinal());
            this.dwType = dwType;
        }

        private void setCurrency(String currency) {
            this.currency = currency;
        }

        private void setBalance(double balance) {
            this.balance = balance;
        }

        private void setSender(String sender) throws ParameterException {
            Validator.isStr(sender, 50);
            this.sender = sender;
        }

        private void setFullSms(String fullSms) throws ParameterException {
            Validator.isStr(this.sender, 500);
            this.fullSms = fullSms;
        }

        private void setSmsDate(String smsDate) throws ParameterException {
            Validator.isDate(smsDate);
            this.smsDate = smsDate;
        }

        private void setSmsType(int smsType) throws ParameterException {
            Validator.in(smsType, Constants.SMSType.SMS.ordinal(), Constants.SMSType.MMS.ordinal(), Constants.SMSType.NOTIFICATION.ordinal());
            this.smsType = smsType;
        }

        private void setIsOffset(int isOffset) throws ParameterException {
            Validator.in(isOffset, 0, 1);
            this.isOffset = isOffset;
        }

        private void setIsDuplicate(int isDuplicate) throws ParameterException {
            Validator.in(this.isOffset, 0, 1);
            this.isDuplicate = isDuplicate;
        }

        private void setMemo(String memo) throws ParameterException {
            Validator.isStr(this.sender, 300);
            this.memo = memo;
        }

        private void setSpentLatitude(double spentLatitude) {
            this.spentLatitude = spentLatitude;
        }

        private void setSpentLongitude(double spentLongitude) {
            this.spentLongitude = spentLongitude;
        }

        private void setCategoryCode(int categoryCode) throws ParameterException {
            Validator.len("" + categoryCode, 6);
            this.categoryCode = categoryCode;
        }

        private void setCompanyId(int companyId) throws ParameterException {
            Validator.notZero(companyId);
            this.companyId = companyId;
        }

        private void setClassCode(String classCode) throws ParameterException {
            Validator.isStr(classCode, 10);
            this.classCode = classCode;
        }

        private void setRegId(int regId) {
            this.regId = regId;
        }
    }
}

