package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.util.Validator;

import java.io.Serializable;
import java.util.ArrayList;

public class LogRequest extends Request implements Serializable {

    private String eventName;
    private ArrayList<Attribute> attributes;


    public LogRequest(String eventName) {
        this.eventName = eventName;
    }

    public String getEventName() {
        return eventName;
    }

    public ArrayList<Attribute> getAttributes() {
        return attributes;
    }

    @Override
    public void checkParams() throws ParameterException {
        Validator.isStr(eventName, 100);
    }

    public static class Attribute {
        private String key;
        private String value;

        public String getKey() {
            return key;
        }

        public String getValue() {
            return value;
        }
    }
}
