/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentManager;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.webkit.WebView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.ProgressDialogFragment;
import com.tenqube.visual_third.ui.WebAppInterface;
import com.tenqube.visual_third.util.Utils;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebActivity
extends AppCompatActivity {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int FINISH = 10;
    public static final int PROGRESS = 11;
    public static final int SHOW_PROGRESS_BAR = 12;
    public static final int ERROR = 13;
    private ProgressDialogFragment progressDialog;
    private PrefManager prefManager;
    private VisualApi api;
    private VisualRepository repository;
    private boolean isPageLoaded;
    private boolean shouldRefresh;
    private String path;
    private WebView webview;
    private BulkLoader bulkLoader;
    private WebAppInterface webAppInterface;
    private SwipeRefreshLayout swipeRefreshLayout;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 11: {
                    Bundle bundle;
                    if (VisualWebActivity.this.progressDialog == null || !VisualWebActivity.this.progressDialog.isAdded() || (bundle = msg.getData()) == null) break;
                    VisualWebActivity.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                    break;
                }
                case 12: {
                    try {
                        if (VisualWebActivity.this.progressDialog == null) {
                            VisualWebActivity.this.progressDialog = ProgressDialogFragment.newInstance((Context)VisualWebActivity.this);
                            VisualWebActivity.this.progressDialog.setCancelable(false);
                        }
                        if (VisualWebActivity.this.progressDialog.isAdded()) break;
                        FragmentManager fragmentManager = VisualWebActivity.this.getSupportFragmentManager();
                        VisualWebActivity.this.progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                    }
                    catch (Exception e) {
                        VisualWebActivity.this.progressDialog = null;
                    }
                    break;
                }
                case 10: {
                    VisualWebActivity.this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
                    if (VisualWebActivity.this.progressDialog != null && VisualWebActivity.this.progressDialog.isAdded()) {
                        VisualWebActivity.this.progressDialog.dismiss();
                    }
                    VisualWebActivity.this.loadUrl(VisualWebActivity.this.path);
                    break;
                }
                default: {
                    LogUtil.LOGI((String)TAG, (String)("handler:" + msg.what), (boolean)ParserService.mIsDebug);
                }
            }
            return false;
        }
    });

    public static void startActivity(Context context, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.addFlags(0x4020000);
        context.startActivity(intent);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.api = VisualApi.getInstance(this.getApplicationContext());
            this.repository = VisualRepository.getInstance(this.getApplicationContext());
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            this.setContentView(R.layout.activity_visual_web);
            this.swipeRefreshLayout = (SwipeRefreshLayout)this.findViewById(R.id.swipe_refresh_layout);
            this.swipeRefreshLayout.setEnabled(false);
            this.swipeRefreshLayout.setColorSchemeResources(new int[]{R.color.colorPopupRed, R.color.colorPopupRed, R.color.colorPopupRed});
            this.swipeRefreshLayout.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

                public void onRefresh() {
                    VisualWebActivity.this.swipeRefreshLayout.setRefreshing(false);
                    VisualWebActivity.this.webview.reload();
                }
            });
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.webAppInterface = new WebAppInterface(this, this.webview, new BottomDialog((Activity)this), VisualRepository.getInstance(this.getApplicationContext()), this.api);
            this.webview.addJavascriptInterface((Object)this.webAppInterface, "visual");
            this.webview.getSettings().setJavaScriptEnabled(true);
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
                LogUtil.LOGI((String)TAG, (String)"\ubc8c\ud06c \ud30c\uc2f1 \uc9c4\ud589", (boolean)ParserService.mIsDebug);
                this.startBulkParsing();
            } else {
                this.syncCategory();
                this.syncAnalysis();
                this.loadUrl(this.path);
                this.syncSearchFailedTransactions();
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }

    public void onPagedLoaded(final boolean shouldRefresh) {
        this.shouldRefresh = shouldRefresh;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                VisualWebActivity.this.isPageLoaded = true;
                VisualWebActivity.this.swipeRefreshLayout.setEnabled(shouldRefresh);
            }
        });
    }

    private void loadUrl(String path) {
        if (this.webview != null) {
            this.isPageLoaded = false;
            String url = this.getBaseUrl() + path;
            this.webview.loadUrl(url);
        }
    }

    private String getBaseUrl() {
        String url = this.prefManager.loadStringValue("TENQUBE_WEB_URL", "");
        url = url.replace("https://", "");
        url = url.replace("http://", "");
        String version = "v2.4.";
        return "http://" + version + url + "/";
    }

    private void syncSearchFailedTransactions() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SearchCompanyRequest request = VisualWebActivity.this.repository.loadFailedSearchTransactions();
                if (request != null) {
                    VisualWebActivity.this.api.searchCompany(request);
                }
                VisualWebActivity.this.api.syncTransactions(null);
            }
        }).start();
    }

    private void syncCategory() {
        this.api.syncCategory(this.prefManager.loadIntValue("TENQUBE_CATEGORY_VERSION", 12));
    }

    private void syncAnalysis() {
        this.api.syncAnalysis(this.prefManager.loadIntValue("TENQUBE_ANALYSIS_VERSION", 0));
    }

    private void startBulkParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader = new BulkLoader((Context)VisualWebActivity.this, VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(10);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LogUtil.LOGI((String)TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.handler.sendEmptyMessage(12);
                    LogUtil.LOGI((String)TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(13);
                }
            }
        }).start();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.webAppInterface == null) break;
                    this.webAppInterface.onNotiCallback(json);
                    break;
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.isPageLoaded && this.webAppInterface != null) {
                this.webAppInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    public void onResume() {
        super.onResume();
        this.overridePendingTransition(0, 0);
    }

    public void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }

    public void onScrollChanged(final int pos) {
        this.swipeRefreshLayout.post(new Runnable(){

            @Override
            public void run() {
                if (VisualWebActivity.this.shouldRefresh) {
                    if (pos == 0) {
                        VisualWebActivity.this.swipeRefreshLayout.setEnabled(true);
                    } else {
                        VisualWebActivity.this.swipeRefreshLayout.setEnabled(false);
                    }
                }
            }
        });
    }
}

