/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.util.SparseArray;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.DailyAnalysis;
import com.tenqube.visual_third.analysis.LastSpentAnalysis;
import com.tenqube.visual_third.analysis.MonthlyAnalysis;
import com.tenqube.visual_third.analysis.WeeklyAnalysis;
import com.tenqube.visual_third.model.analysis.AggregationValue;
import com.tenqube.visual_third.model.analysis.Result;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class FunctionMap {
    public static final int month_0 = 1;
    public static final int month_0_sum = 2;
    public static final int month_0_cnt = 3;
    public static final int month_0_avg = 4;
    public static final int month_0_sum_credit = 5;
    public static final int month_0_sum_check = 6;
    public static final int month_0_sum_cash = 7;
    public static final int month_1 = 28;
    public static final int month_1_sum = 29;
    public static final int month_1_cnt = 30;
    public static final int month_1_avg = 31;
    public static final int month_1_sum_same_period = 32;
    public static final int month_1_sum_credit = 33;
    public static final int month_1_sum_check = 34;
    public static final int month_1_sum_cash = 35;
    public static final int month_1_category_first_name = 36;
    public static final int month_1_category_first_sum = 37;
    public static final int month_1_category_first_percent = 38;
    public static final int month_1_category_second_name = 39;
    public static final int month_1_category_second_sum = 40;
    public static final int month_1_category_second_percent = 41;
    public static final int month_1_category_third_name = 42;
    public static final int month_1_category_third_sum = 43;
    public static final int month_1_category_third_percent = 44;
    public static final int month_1_mid_alcohol_sum = 54;
    public static final int month_1_mid_coffee_sum = 55;
    public static final int month_1_mid_mart_sum = 56;
    public static final int month_1_mid_convenience_sum = 57;
    public static final int month_1_mid_category_first_name = 59;
    public static final int month_1_mid_category_first_sum = 60;
    public static final int month_1_mid_category_first_percent = 61;
    public static final int month_1_mid_category_second_name = 62;
    public static final int month_1_mid_category_second_sum = 63;
    public static final int month_1_mid_category_second_percent = 64;
    public static final int month_1_mid_category_third_name = 65;
    public static final int month_1_mid_category_third_sum = 66;
    public static final int month_1_mid_category_third_percent = 67;
    public static final int month_1_mid_alcohol_cnt = 68;
    public static final int month_2 = 69;
    public static final int month_2_sum = 70;
    public static final int month_2_cnt = 71;
    public static final int month_2_avg = 72;
    public static final int month_2_mid_alcohol_sum = 95;
    public static final int month_2_mid_coffee_sum = 96;
    public static final int month_2_mid_mart_sum = 97;
    public static final int month_2_mid_convenience_sum = 98;
    public static final int month_3 = 99;
    public static final int month_3_sum = 100;
    public static final int month_3_cnt = 101;
    public static final int month_3_avg = 102;
    public static final int month_3_mid_alcohol_sum = 125;
    public static final int month_3_mid_coffee_sum = 126;
    public static final int month_3_mid_mart_sum = 127;
    public static final int month_3_mid_convenience_sum = 128;
    public static final int three_month_mid_alcohol_sum = 129;
    public static final int three_month_mid_coffee_sum = 130;
    public static final int three_month_mid_mart_sum = 131;
    public static final int three_month_mid_convenience_sum = 132;
    public static final int three_month_mid_coffee_cnt = 133;
    public static final int three_month_mid_coffee_country = 134;
    public static final int three_month_mid_taxi_sum = 135;
    public static final int three_month_mid_taxi_am_sum = 136;
    public static final int three_month_book_sum = 137;
    public static final int last_hospital_date = 164;
    public static final int last_movie_date = 165;
    public static final int last_movie_keyword = 166;
    public static final int three_month_movie_cnt = 167;
    public static final int last_nail_date = 168;
    public static final int last_nail_keyword = 169;
    public static final int three_month_nail_cnt = 170;
    public static final int last_hair_date = 171;
    public static final int last_hair_keyword = 172;
    public static final int three_month_hair_avg_cnt = 173;
    public static final int yesterday_sum = 174;
    public static final int yesterday_max_keyword = 175;
    public static final int yesterday_max_spent_money = 176;
    public static final int three_month_mid_coffee_am_sum = 177;
    public static final int three_month_mid_coffee_country_value = 178;
    public static final int last_hair_diff_day = 179;
    public static final int last_nail_diff_day = 180;
    public static final int last_hospital_diff_day = 181;
    public static final int last_movie_diff_day = 182;
    public static final int three_month_large_food_cnt = 186;
    public static final int three_month_mid_fastfood_cnt = 188;
    public static final int three_month_mid_fastfood_percent = 189;
    public static final int three_month_first_mid_fastfood_keyword = 190;
    public static final int three_month_first_mid_fastfood_cnt = 191;
    public static final int three_month_second_mid_fastfood_keyword = 192;
    public static final int three_month_second_mid_fastfood_cnt = 193;
    public static final int three_month_third_mid_fastfood_keyword = 194;
    public static final int three_month_third_mid_fastfood_cnt = 195;
    public static final int past_day = 196;
    public static final int empty = 197;
    public static final int month_1_large_category_sum = 198;
    public static final int month_1_large_category_name = 199;
    public static final int today = 200;
    public static final int month_1_mid_taxi_sum = 201;
    public static final int just_year_sum = 203;
    public static final int month_1_alcohol_type = 204;
    public static final int user_sex = 205;
    public static final int month_0_same_period_percent = 206;
    public static final int month_0_mid_coffee_sum = 207;
    public static final int yesterday_alcohol_sum = 208;
    public static final int three_month_avg = 214;
    public static final int three_month_mid_coffee_week_avg = 216;
    public static final int month_2_mid_taxi_sum = 219;
    public static final int month_3_mid_taxi_sum = 223;
    public static final int three_month_sum = 224;
    public static final int month_0_same_period_more_or_less_str = 225;
    public static final int month_1_same_period_end_day = 226;
    public static final int three_month_book_diff_sum = 227;
    public static final int month_1_large_category_code = 228;
    public static final int month_1_alcohol_type_image_name = 229;
    public static final int three_month_week_avg = 230;
    public static final int three_month_day_avg = 231;
    public static final int week_0_sum = 232;
    public static final int week_1_sum = 233;
    public static final int week_1_percent = 234;
    public static final int yesterday_max_sum = 236;
    public static final int day_of_week = 237;
    public static final int mid_image = 238;
    public static final int same_period_image = 239;
    public static final SparseArray<Result> values = new SparseArray();
    public static final SparseArray<ArrayList<Integer>> tranIds = new SparseArray();
    public static final int LV0 = 0;
    public static final int NORMAL = 1;
    public static final int FIRSTDOT = 2;
    public static final int PERCENT = 3;
    private MonthlyAnalysis monthlyAnalysis0;
    private MonthlyAnalysis monthlyAnalysis1;
    private MonthlyAnalysis monthlyAnalysis2;
    private MonthlyAnalysis monthlyAnalysis3;
    private WeeklyAnalysis weeklyAnalysis0;
    private WeeklyAnalysis weeklyAnalysis1;
    private DailyAnalysis dailyAnalysis1;
    private LastSpentAnalysis movie;
    private LastSpentAnalysis nail;
    private LastSpentAnalysis hair;
    private LastSpentAnalysis hospital;

    void calculate(ArrayList<Transaction> transactions) throws Exception {
        Thread[] threads = new Thread[11];
        this.monthlyAnalysis0 = new MonthlyAnalysis(transactions, 0);
        threads[0] = new Thread(this.monthlyAnalysis0);
        this.monthlyAnalysis1 = new MonthlyAnalysis(transactions, 1);
        threads[1] = new Thread(this.monthlyAnalysis1);
        this.monthlyAnalysis2 = new MonthlyAnalysis(transactions, 2);
        threads[2] = new Thread(this.monthlyAnalysis2);
        this.monthlyAnalysis3 = new MonthlyAnalysis(transactions, 3);
        threads[3] = new Thread(this.monthlyAnalysis3);
        this.weeklyAnalysis0 = new WeeklyAnalysis(transactions, 0);
        threads[4] = new Thread(this.weeklyAnalysis0);
        this.weeklyAnalysis1 = new WeeklyAnalysis(transactions, 1);
        threads[5] = new Thread(this.weeklyAnalysis1);
        this.dailyAnalysis1 = new DailyAnalysis(transactions, 1);
        threads[6] = new Thread(this.dailyAnalysis1);
        this.movie = new LastSpentAnalysis(transactions, 5611);
        threads[7] = new Thread(this.movie);
        this.nail = new LastSpentAnalysis(transactions, 4614);
        threads[8] = new Thread(this.nail);
        this.hair = new LastSpentAnalysis(transactions, 4611);
        threads[9] = new Thread(this.hair);
        this.hospital = new LastSpentAnalysis(transactions, 4413, 4414, 4412, 4411);
        threads[10] = new Thread(this.hospital);
        for (Thread thread : threads) {
            thread.start();
            thread.join();
        }
        this.setDefault();
        this.setYesterday();
        this.setWeekly();
        this.setMonth0();
        this.setMonth1();
        this.setMonth2();
        this.setMonth3();
        this.setThreeMonth();
        this.setLastSpent();
        this.setTranIds();
    }

    private void setDefault() {
        values.put(200, (Object)new Result(Calendar.getInstance().get(5), 2));
        values.put(205, (Object)new Result("0"));
    }

    private void setMonth0() {
        if (this.monthlyAnalysis0 == null) {
            return;
        }
        values.put(1, (Object)new Result(this.monthlyAnalysis0.monthStr));
        AggregationValue month = this.monthlyAnalysis0.month.get("");
        if (month != null) {
            values.put(2, (Object)new Result(month.getSum(), 0));
            values.put(3, (Object)new Result(month.getCnt(), 0));
            values.put(4, (Object)new Result(month.getAvg(), 0));
        }
        values.put(5, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis0.cardType, "1", 0), 0));
        values.put(6, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis0.cardType, "0", 0), 0));
        values.put(7, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis0.cardType, "3", 0), 0));
        double percent = AnalysisHelper.getPercentValue(month == null ? 0.0 : month.getSum(), this.monthlyAnalysis1.samePeriodSum);
        values.put(206, (Object)new Result(percent, 3));
        if (percent > 0.0) {
            values.put(225, (Object)new Result("\ub9ce\uc774"));
            values.put(239, (Object)new Result("lv0_monthly_up"));
        } else {
            values.put(225, (Object)new Result("\uc801\uac8c"));
            values.put(239, (Object)new Result("lv0_monthly_down"));
        }
        values.put(207, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis0.mcode, "2411", 0), 0));
        values.put(196, (Object)new Result(Calendar.getInstance().get(5), 2));
    }

    private void setMonth1() {
        values.put(28, (Object)new Result(this.monthlyAnalysis1.monthStr));
        AggregationValue month = this.monthlyAnalysis1.month.get("");
        if (month != null) {
            values.put(29, (Object)new Result(month.getSum(), 0));
            values.put(30, (Object)new Result(month.getCnt(), 0));
            values.put(31, (Object)new Result(month.getAvg(), 0));
            values.put(32, (Object)new Result(this.monthlyAnalysis1.samePeriodSum, 0));
            values.put(33, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.cardType, "1", 0), 0));
            values.put(34, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.cardType, "0", 0), 0));
            values.put(35, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.cardType, "3", 0), 0));
            AggregationValue alcohol = this.monthlyAnalysis1.mcode.get("2613");
            if (alcohol != null) {
                values.put(54, (Object)new Result(alcohol.getSum(), 0));
                values.put(68, (Object)new Result(alcohol.getCnt(), 2));
                String[] alcohols = AnalysisHelper.getAlcoholType(alcohol.getCnt());
                values.put(204, (Object)new Result(alcohols[0]));
                values.put(229, (Object)new Result(alcohols[1]));
            }
            values.put(55, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "2411", 0), 0));
            values.put(56, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "3216", 0), 0));
            values.put(57, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "3211", 0), 0));
            values.put(201, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "6216", 0), 0));
            values.put(226, (Object)new Result(Calendar.getInstance().get(5), 2));
            this.setLargeCategoryTop3(month.getSum());
            this.setMidTop3();
        }
    }

    private void setLargeCategoryTop3(double monthSum) {
        AggregationValue large2;
        ArrayList<AggregationValue> larges = new ArrayList<AggregationValue>(this.monthlyAnalysis1.lcode.values());
        AnalysisHelper.desc(larges);
        int i = 0;
        for (AggregationValue large2 : larges) {
            if (i == 3) break;
            Result name = new Result(large2.getTitle());
            Result sum = new Result(large2.getSum(), 1);
            double percentValue = large2.getSum() * 100.0 / monthSum;
            Result percent = new Result(percentValue, 3);
            switch (i) {
                case 0: {
                    values.put(36, (Object)name);
                    values.put(37, (Object)sum);
                    values.put(38, (Object)percent);
                    break;
                }
                case 1: {
                    values.put(39, (Object)name);
                    values.put(40, (Object)sum);
                    values.put(41, (Object)percent);
                    break;
                }
                case 2: {
                    values.put(42, (Object)name);
                    values.put(43, (Object)sum);
                    values.put(44, (Object)percent);
                }
            }
            ++i;
        }
        int rand = Utils.getRand(0, larges.size() > 3 ? 3 : larges.size());
        large2 = larges.get(rand);
        values.put(228, (Object)new Result(large2.getKey()));
        values.put(198, (Object)new Result(large2.getSum(), 0));
        values.put(199, (Object)new Result(large2.getTitle()));
        values.put(238, (Object)new Result(AnalysisHelper.getMidImage(large2.getKey())));
    }

    private void setMidTop3() {
        Result result = (Result)values.get(228);
        if (result == null) {
            return;
        }
        String lCode = result.getValue();
        result = (Result)values.get(198);
        if (result == null) {
            return;
        }
        double largeSum = result.getAmount();
        ArrayList<AggregationValue> mediums = new ArrayList<AggregationValue>(this.monthlyAnalysis1.mcode.values());
        AnalysisHelper.desc(mediums);
        int i = 0;
        for (AggregationValue medium : mediums) {
            if (!lCode.equals(medium.getKey().substring(0, 2))) continue;
            if (i == 3) break;
            Result name = new Result(medium.getTitle());
            Result sum = new Result(medium.getSum(), 1);
            double percentValue = medium.getSum() * 100.0 / largeSum;
            Result percent = new Result(percentValue, 3);
            switch (i) {
                case 0: {
                    values.put(59, (Object)name);
                    values.put(60, (Object)sum);
                    values.put(61, (Object)percent);
                    break;
                }
                case 1: {
                    values.put(62, (Object)name);
                    values.put(63, (Object)sum);
                    values.put(64, (Object)percent);
                    break;
                }
                case 2: {
                    values.put(65, (Object)name);
                    values.put(66, (Object)sum);
                    values.put(67, (Object)percent);
                }
            }
            ++i;
        }
    }

    private void setMonth2() {
        values.put(69, (Object)new Result(this.monthlyAnalysis2.monthStr));
        AggregationValue month = this.monthlyAnalysis2.month.get("");
        if (month != null) {
            values.put(70, (Object)new Result(month.getSum(), 0));
            values.put(71, (Object)new Result(month.getCnt(), 0));
            values.put(72, (Object)new Result(month.getAvg(), 0));
            values.put(95, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "2613", 0), 0));
            values.put(96, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "2411", 0), 0));
            values.put(97, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "3216", 0), 0));
            values.put(98, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "3211", 0), 0));
            values.put(219, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "6216", 0), 0));
        }
    }

    private void setMonth3() {
        values.put(99, (Object)new Result(this.monthlyAnalysis3.monthStr));
        AggregationValue month = this.monthlyAnalysis3.month.get("");
        if (month != null) {
            values.put(100, (Object)new Result(month.getSum(), 0));
            values.put(101, (Object)new Result(month.getCnt(), 0));
            values.put(102, (Object)new Result(month.getAvg(), 0));
            values.put(125, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "2613", 0), 0));
            values.put(126, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "2411", 0), 0));
            values.put(127, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "3216", 0), 0));
            values.put(128, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "3211", 0), 0));
            values.put(223, (Object)new Result(AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "6216", 0), 0));
        }
    }

    private void setThreeMonth() {
        int threeMonthTotalDay = this.getThreeMonthTotalDay();
        this.setThreeMonthAggregation(threeMonthTotalDay);
        this.setThreeMonthCoffeeCountry(threeMonthTotalDay);
        this.setThreeMonthBookSum();
        this.setThreeMonthFastFood();
        this.setThreeMonthHair(threeMonthTotalDay);
        this.setThreeMonthNail();
        this.setThreeMonthMart();
        this.setThreeMonthConvenience();
        this.setThreeMonthMovie();
        this.setThreeMonthTaxi();
        this.setThreeMonthAlcohol();
    }

    private int getThreeMonthTotalDay() {
        Calendar before = Calendar.getInstance();
        before.set(5, 1);
        before.add(2, -4);
        Calendar after = Calendar.getInstance();
        after.set(5, 1);
        after.add(2, -1);
        return Utils.getDiffDay(before, after);
    }

    private void setThreeMonthAggregation(int totalDay) {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.month, "", 0);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.month, "", 0);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.month, "", 0);
        double threeMonthSum = m1 + m2 + m3;
        int divider = 0;
        if (m3 != 0.0) {
            divider = 3;
        } else if (m2 != 0.0) {
            divider = 2;
        } else if (m1 != 0.0) {
            divider = 1;
        }
        double threeMonthAvg = divider == 0 ? 0.0 : threeMonthSum / (double)divider;
        double threeMonthDayAvg = totalDay == 0 ? 0.0 : threeMonthSum / (double)totalDay;
        double threeMonthWeekAvg = threeMonthDayAvg * 7.0;
        values.put(224, (Object)new Result(threeMonthSum, 0));
        values.put(230, (Object)new Result(threeMonthWeekAvg, 0));
        values.put(231, (Object)new Result(threeMonthWeekAvg, 0));
        values.put(214, (Object)new Result(threeMonthAvg, 0));
    }

    private void setThreeMonthCoffeeCountry(int totalDay) {
        double s1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "2411", 0);
        double s2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "2411", 0);
        double s3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "2411", 0);
        values.put(130, (Object)new Result(s1 + s2 + s3, 0));
        double morning = this.monthlyAnalysis1.morningCoffeeSum.getSum() + this.monthlyAnalysis2.morningCoffeeSum.getSum() + this.monthlyAnalysis3.morningCoffeeSum.getSum();
        values.put(177, (Object)new Result(morning, 0));
        double c1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "2411", 1);
        double c2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "2411", 1);
        double c3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "2411", 1);
        double threeMonthCoffeeCnt = c1 + c2 + c3;
        double threeMonthCoffeeWeekAvg = totalDay == 0 ? 0.0 : threeMonthCoffeeCnt * 7.0 / (double)totalDay;
        String[] coffeeType = AnalysisHelper.getCoffeeCountry(threeMonthCoffeeWeekAvg);
        values.put(133, (Object)new Result(threeMonthCoffeeCnt, 2));
        values.put(134, (Object)new Result(coffeeType[0]));
        values.put(178, (Object)new Result(coffeeType[1]));
        values.put(216, (Object)new Result(threeMonthCoffeeWeekAvg, 2));
    }

    private void setThreeMonthBookSum() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "5612", 0);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "5612", 0);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "5612", 0);
        double threeMonthSum = m1 + m2 + m3;
        double diff = threeMonthSum - 54300.0;
        values.put(137, (Object)new Result(threeMonthSum, 0));
        values.put(227, (Object)new Result(diff, 0));
    }

    private void setThreeMonthFastFood() {
        double l3;
        double l2;
        double l1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.lcode, "22", 1);
        double lcnt = l1 + (l2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.lcode, "22", 1)) + (l3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.lcode, "22", 1));
        if (lcnt == 0.0) {
            return;
        }
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "2212", 1);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "2212", 1);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "2212", 1);
        double mcnt = m1 + m2 + m3;
        double percent = mcnt * 100.0 / lcnt;
        values.put(186, (Object)new Result(lcnt, 2));
        values.put(188, (Object)new Result(mcnt, 2));
        values.put(189, (Object)new Result(percent, 3));
        HashMap<String, AggregationValue> totalFastFoods = new HashMap<String, AggregationValue>();
        if (this.monthlyAnalysis1.fastfood != null) {
            totalFastFoods.putAll(this.monthlyAnalysis1.fastfood);
        }
        if (this.monthlyAnalysis2.fastfood != null) {
            totalFastFoods.putAll(this.monthlyAnalysis2.fastfood);
        }
        if (this.monthlyAnalysis2.fastfood != null) {
            totalFastFoods.putAll(this.monthlyAnalysis3.fastfood);
        }
        ArrayList<AggregationValue> keywords = new ArrayList<AggregationValue>(totalFastFoods.values());
        AnalysisHelper.desc(keywords);
        int i = 0;
        for (AggregationValue keyword : keywords) {
            if (i == 3) break;
            Result name = new Result(keyword.getTitle());
            Result cnt = new Result(keyword.getCnt(), 2);
            switch (i) {
                case 0: {
                    values.put(190, (Object)name);
                    values.put(191, (Object)cnt);
                    break;
                }
                case 1: {
                    values.put(192, (Object)name);
                    values.put(193, (Object)cnt);
                    break;
                }
                case 2: {
                    values.put(194, (Object)name);
                    values.put(195, (Object)cnt);
                }
            }
            ++i;
        }
    }

    private void setThreeMonthHair(int totalDay) {
        double m3;
        double m2;
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "4611", 1);
        double hairCnt = m1 + (m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "4611", 1)) + (m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "4611", 1));
        double avg = hairCnt == 0.0 ? 0.0 : (double)totalDay / hairCnt;
        values.put(173, (Object)new Result(avg, 2));
    }

    private void setThreeMonthMovie() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "5611", 1);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "5611", 1);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "5611", 1);
        double movieCnt = m1 + m2 + m3;
        values.put(167, (Object)new Result(movieCnt, 2));
    }

    private void setThreeMonthNail() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "4614", 1);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "4614", 1);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "4614", 1);
        double nailCnt = m1 + m2 + m3;
        values.put(170, (Object)new Result(nailCnt, 2));
    }

    private void setThreeMonthTaxi() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "6216", 0);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "6216", 0);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "6216", 0);
        double taxiSum = m1 + m2 + m3;
        double taxiAmSum = this.monthlyAnalysis1.morningTaxiSum.getSum() + this.monthlyAnalysis2.morningTaxiSum.getSum() + this.monthlyAnalysis3.morningTaxiSum.getSum();
        values.put(135, (Object)new Result(taxiSum, 0));
        values.put(136, (Object)new Result(taxiAmSum, 0));
    }

    private void setThreeMonthConvenience() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "3211", 0);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "3211", 0);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "3211", 0);
        double conSum = m1 + m2 + m3;
        values.put(132, (Object)new Result(conSum, 0));
    }

    private void setThreeMonthMart() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "3216", 0);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "3216", 0);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "3216", 0);
        double martSum = m1 + m2 + m3;
        values.put(131, (Object)new Result(martSum, 0));
    }

    private void setThreeMonthAlcohol() {
        double m1 = AnalysisHelper.getAggregate(this.monthlyAnalysis1.mcode, "2613", 0);
        double m2 = AnalysisHelper.getAggregate(this.monthlyAnalysis2.mcode, "2613", 0);
        double m3 = AnalysisHelper.getAggregate(this.monthlyAnalysis3.mcode, "2613", 0);
        double alcoholSum = m1 + m2 + m3;
        values.put(129, (Object)new Result(alcoholSum, 0));
    }

    private void setYesterday() {
        values.put(174, (Object)new Result(AnalysisHelper.getAggregate(this.dailyAnalysis1.yesterday, "", 0), 0));
        values.put(208, (Object)new Result(AnalysisHelper.getAggregate(this.dailyAnalysis1.alcohol, "", 0), 0));
        if (this.dailyAnalysis1.maxTransaction != null) {
            values.put(175, (Object)new Result(this.dailyAnalysis1.maxTransaction.getTransaction().getKeyword()));
            values.put(236, (Object)new Result(this.dailyAnalysis1.maxTransaction.getTransaction().getSpentMoney(), 1));
        }
    }

    private void setWeekly() {
        values.put(232, (Object)new Result(AnalysisHelper.getAggregate(this.weeklyAnalysis0.weekly, "", 0), 0));
        values.put(233, (Object)new Result(AnalysisHelper.getAggregate(this.weeklyAnalysis1.weekly, "", 0), 0));
        double sum = AnalysisHelper.getAggregate(this.weeklyAnalysis1.weekly, "", 0);
        double amount = AnalysisHelper.getFuncAmount(230);
        double percent = AnalysisHelper.getPercentValue(sum, amount);
        values.put(234, (Object)new Result(percent, 3));
    }

    private void setLastSpent() {
        if (this.hospital.lastTransaction != null) {
            values.put(164, (Object)new Result(this.hospital.lastTransaction.getTransaction().getSpentDate()));
            values.put(181, (Object)new Result(this.hospital.difDay, 2));
        }
        if (this.movie.lastTransaction != null) {
            values.put(165, (Object)new Result(this.movie.lastTransaction.getTransaction().getSpentDate()));
            values.put(182, (Object)new Result(this.movie.difDay, 2));
            values.put(166, (Object)new Result(this.movie.lastTransaction.getTransaction().getKeyword()));
        }
        if (this.nail.lastTransaction != null) {
            values.put(168, (Object)new Result(this.nail.lastTransaction.getTransaction().getSpentDate()));
            values.put(180, (Object)new Result(this.nail.difDay, 2));
            values.put(169, (Object)new Result(this.nail.lastTransaction.getTransaction().getKeyword()));
        }
        if (this.hair.lastTransaction != null) {
            values.put(171, (Object)new Result(this.hair.lastTransaction.getTransaction().getSpentDate()));
            values.put(179, (Object)new Result(this.hair.difDay, 2));
            values.put(172, (Object)new Result(this.hair.lastTransaction.getTransaction().getKeyword()));
        }
    }

    private void setTranIds() {
        tranIds.put(180, AnalysisHelper.getTranIds(this.nail.filteredTransactions));
        tranIds.put(182, AnalysisHelper.getTranIds(this.movie.filteredTransactions));
        tranIds.put(179, AnalysisHelper.getTranIds(this.hair.filteredTransactions));
        tranIds.put(164, AnalysisHelper.getTranIds(this.hospital.filteredTransactions));
        tranIds.put(164, AnalysisHelper.getTranIds(this.hospital.filteredTransactions));
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "5612"));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis2.mcode, "5612"));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis3.mcode, "5612"));
        tranIds.put(137, ids);
        ids = new ArrayList();
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "2212"));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis2.mcode, "2212"));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis3.mcode, "2212"));
        tranIds.put(186, ids);
        AggregationValue value = this.monthlyAnalysis1.month.get("");
        tranIds.put(198, value == null ? new ArrayList<Integer>() : value.getTranIds());
        ids = new ArrayList();
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "2411"));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis2.mcode, "2411"));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis3.mcode, "2411"));
        tranIds.put(133, ids);
        ids = new ArrayList();
        ids.addAll(this.monthlyAnalysis1.morningCoffeeSum.getIds());
        ids.addAll(this.monthlyAnalysis2.morningCoffeeSum.getIds());
        ids.addAll(this.monthlyAnalysis3.morningCoffeeSum.getIds());
        tranIds.put(177, ids);
        ids = new ArrayList();
        ids.addAll(this.monthlyAnalysis1.morningTaxiSum.getIds());
        ids.addAll(this.monthlyAnalysis2.morningTaxiSum.getIds());
        ids.addAll(this.monthlyAnalysis3.morningTaxiSum.getIds());
        tranIds.put(136, ids);
        tranIds.put(55, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "2411"));
        tranIds.put(54, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "2613"));
        tranIds.put(56, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "3216"));
        tranIds.put(57, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "3211"));
        tranIds.put(201, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.mcode, "6216"));
        tranIds.put(5, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis0.cardType, "1"));
        tranIds.put(33, AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.cardType, "1"));
        tranIds.put(233, AnalysisHelper.getAggregatedTranIds(this.weeklyAnalysis1.weekly, "0"));
        ids = new ArrayList();
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.month, ""));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis2.month, ""));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis3.month, ""));
        tranIds.put(224, ids);
        ids = new ArrayList();
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis0.month, ""));
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.month, ""));
        tranIds.put(2, ids);
        ids = new ArrayList();
        ids.addAll(AnalysisHelper.getAggregatedTranIds(this.monthlyAnalysis1.month, ""));
        tranIds.put(29, ids);
        tranIds.put(174, AnalysisHelper.getAggregatedTranIds(this.dailyAnalysis1.yesterday, ""));
        tranIds.put(208, AnalysisHelper.getAggregatedTranIds(this.dailyAnalysis1.alcohol, "2613"));
    }
}

