/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import com.tenqube.visual_third.analysis.AnalysisHelper;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.FunctionMap;
import com.tenqube.visual_third.entity.Condition;
import com.tenqube.visual_third.entity.JoinedContent;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.repository.AnalysisRepository;
import com.tenqube.visual_third.util.Utils;
import java.util.ArrayList;
import java.util.Iterator;

public class AnalysisServiceImpl
implements AnalysisService {
    private final Context context;
    private final AnalysisRepository repository;
    private ArrayList<Analysis> results = new ArrayList();
    private long time;
    private boolean isReceived;
    private LocalBroadCastReceiver receiver = new LocalBroadCastReceiver();

    public AnalysisServiceImpl(Context context) {
        this.context = context;
        this.repository = AnalysisRepository.getInstance(context);
        IntentFilter filter = new IntentFilter();
        filter.addAction("tenqube.intent.action.ACTION_TRANSACTION_RECEIVED");
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)this.receiver, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<Analysis> loadAnalysisList(ArrayList<Transaction> transactions) {
        FunctionMap functionMap = null;
        try {
            this.initCache();
            if (!Utils.isEmpty(this.results)) {
                ArrayList<Analysis> arrayList = this.results;
                return arrayList;
            }
            this.time = System.currentTimeMillis();
            functionMap = new FunctionMap();
            functionMap.calculate(transactions);
            ArrayList<JoinedContent> contents = this.getSatisfiedContents(this.repository.loadContents());
            this.mergeContents(contents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FunctionMap.values.clear();
            FunctionMap.tranIds.clear();
            functionMap = null;
        }
        return this.results;
    }

    private void initCache() {
        if (this.isReceived || this.isTimeOver()) {
            this.isReceived = false;
            this.time = 0L;
            this.results.clear();
        }
    }

    private boolean isTimeOver() {
        return (System.currentTimeMillis() - this.time) / 1000L > 60L;
    }

    private ArrayList<JoinedContent> getSatisfiedContents(ArrayList<JoinedContent> contents) {
        ArrayList<JoinedContent> results = new ArrayList<JoinedContent>();
        for (JoinedContent content : contents) {
            Condition condition;
            boolean isSatisfied = false;
            ArrayList<Condition> conditions = content.getConditions();
            Iterator<Condition> iterator = conditions.iterator();
            while (iterator.hasNext() && (isSatisfied = AnalysisHelper.isSatisfied(condition = iterator.next()))) {
            }
            if (!isSatisfied) continue;
            results.add(content);
        }
        return results;
    }

    private void mergeContents(ArrayList<JoinedContent> contents) {
        for (JoinedContent content : contents) {
            try {
                String image = AnalysisHelper.getValue(content.getContent().getImage());
                String label = AnalysisHelper.getValue(content.getContent().getLabel());
                String lContent = AnalysisHelper.getContent(content.getContent().getlContent(), content.getContent().getlKeys());
                String mContent = AnalysisHelper.getContent(content.getContent().getmContent(), content.getContent().getmKeys());
                Analysis analysis = new Analysis(image, label, lContent, mContent, this.mergeTranIds(content.getContent().getRawKeys()), content.getContent().getCategoryPriority());
                this.results.add(analysis);
            }
            catch (Exception exception) {}
        }
    }

    private ArrayList<Integer> mergeTranIds(String rawKeys) {
        String[] keys;
        ArrayList<Integer> tranIds = new ArrayList<Integer>();
        for (String key : keys = rawKeys.split(",")) {
            ArrayList tempTranIds = (ArrayList)FunctionMap.tranIds.get(Integer.parseInt(key));
            if (tempTranIds == null) continue;
            tranIds.addAll(tempTranIds);
        }
        return tranIds;
    }

    public class LocalBroadCastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            AnalysisServiceImpl.this.isReceived = true;
        }
    }
}

