package com.tenqube.visual_third.model.js;

import com.tenqube.visual_third.exception.ParameterException;

import java.io.Serializable;

import static com.tenqube.visual_third.util.Validator.isStr;

public class SelectBoxInfo extends Request implements Serializable{

    private String name;
    private int orderByType;

    private boolean isSelected;
    private int selectedColor;

    public SelectBoxInfo(String name, int orderByType, int selectedColor) {
        this.name = name;
        this.orderByType = orderByType;
        this.selectedColor = selectedColor;
    }

    public String getName() {
        return name;
    }

    public int getSelectedColor() {
        return selectedColor;
    }

    public int getOrderByType() {
        return orderByType;
    }

    public boolean isSelected() {
        return isSelected;
    }

    public void setSelected(boolean selected) {
        isSelected = selected;
    }

    @Override
    public void checkParams() throws ParameterException {
        isStr(name, 100);
    }
}
