package com.tenqube.visual_third;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.View;

import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.ui.TransactionPopupInfo;
import com.tenqube.visual_third.ui.OnResultListener;
import com.tenqube.visual_third.ui.TransactionPopupActivity;


public class MainActivity extends AppCompatActivity {

    private VisualService visualService;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        try {
            // visual service 생성
            visualService = new VisualServiceImpl(this, "", Constants.PROD);
            visualService.setDebugMode(true); // 개발자 모드 설정 (로그 확인이 가능합니다.)
        } catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    /**
     * 1. 맨처음 가입 이후 파싱 진행 가능
     * 2. 가입 실패시
     * @param view
     */
    public void onSignUp(View view) {
        try {
            visualService.signUp("123412", new OnResultListener() {
                @Override
                public void onResult(int signUpResult, String msg) {

                    switch (signUpResult) {
                        case Constants.SignupResult.SUCCESS: // 가입성공

                            break;

                        case Constants.SignupResult.FAIL: // 가입 실패

                            break;

                        case Constants.SignupResult.ALREADY_JOINED:// 이미 가입됨

                            break;

                    }
                }
            });

        } catch (ParameterException e) { // custId 올바르지 않은경우 custId.length() > 500
            e.printStackTrace();
        } catch (SecurityException e) { //sms, mms 권한이 필요합니다.
            e.printStackTrace();
        }
    }


    /**
     * 팝업 확인 용 함수입니다. sms mms noti 수신시 파싱된경우 다음과 같은 팝업을 나타냅니다.
     *
     * 팝업이 뜨는 경우 ACTION_TRANSACTION_RECEIVED 브로드캐스트 단건 파싱 시 항상 호출합니다.
     *
     *
     * @param view
     */
    public void onSingle(View view) {
        try {
            try {
                TransactionPopupActivity.startActivity(getApplicationContext(), new TransactionPopupInfo(null, null));
            } catch (AuthException e) {
                e.printStackTrace();
            }
        } catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    /**
     *
     * @param view
     */
    public void onWeb(View view) {

        try {
            if (ContextCompat.checkSelfPermission(MainActivity.this,
                    Manifest.permission.READ_SMS)
                    != PackageManager.PERMISSION_GRANTED) {

                // Should we show an explanation?
                if (ActivityCompat.shouldShowRequestPermissionRationale(MainActivity.this,
                        Manifest.permission.READ_SMS)) {



                } else {

                    ActivityCompat.requestPermissions(MainActivity.this,
                            new String[]{Manifest.permission.READ_SMS},
                            0);

                }
            } else {
                visualService.startVisual("1234", new OnResultListener() {
                    @Override
                    public void onResult(int signUpResult, String msg) {

                    }
                });
            }


        } catch (SecurityException e) {
            e.printStackTrace();
        } catch (ParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode,
                                           String permissions[], int[] grantResults) {
        switch (requestCode) {
            case 0: {
                // If request is cancelled, the result arrays are empty.
                if (grantResults.length > 0
                        && grantResults[0] == PackageManager.PERMISSION_GRANTED) {

                    try {
                        visualService.startVisual("1234", new OnResultListener() {
                            @Override
                            public void onResult(int signUpResult, String msg) {

                            }
                        });
                    } catch (ParameterException e) {
                        e.printStackTrace();
                    }
                    // permission was granted, yay! Do the
                    // contacts-related task you need to do.

                } else {

                    // permission denied, boo! Disable the
                    // functionality that depends on this permission.
                }
                return;
            }

        }
    }

}
