/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.Contents;
import com.tenqube.visual_third.model.api.SyncCategoryResponse;
import java.util.ArrayList;

public class ContentsDao {
    private final Db db;

    public ContentsDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Contents> loadContents(int lCode) {
        String query = QueryGenerator.contents(lCode);
        ArrayList<Contents> results = new ArrayList<Contents>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.ContentsTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    public void mergeCategory(SyncCategoryResponse.Category category) {
        try {
            if (category.isDeleted()) {
                this.db.delete(" CATEGORIES ", "_id=?", new String[]{category.getId() + ""});
            } else {
                ContentValues values = new ContentValues();
                values.put("_id", Integer.valueOf(category.getId()));
                values.put("cateCode", Integer.valueOf(category.getCategoryCode()));
                values.put("largeName", category.getLargeCategory());
                values.put("mediumName", category.getMediumCategory());
                values.put("smallName", category.getSmallCategory());
                this.db.insertOnReplace(" CATEGORIES ", values);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

