/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.analysis;

import android.content.Context;
import com.tenqube.visual_third.analysis.AbstractAnalysis;
import com.tenqube.visual_third.analysis.AnalysisService;
import com.tenqube.visual_third.analysis.FactoryAnalysis;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import java.util.ArrayList;

public class AnalysisServiceImpl
implements AnalysisService {
    private final Context context;
    private final int[] CATEGORIES = new int[]{11, 18, 26, 46, 24, 56, 54, 82, 42, 22, 44, 64, 52, 32, 34, 36, 62, 66, 10, 84, 88};
    ArrayList<Analysis> results = new ArrayList();

    public AnalysisServiceImpl(Context context) {
        this.context = context;
    }

    @Override
    public ArrayList<Analysis> loadAnalysisList(final ArrayList<Transaction> transactions) {
        Thread[] threads = new Thread[this.CATEGORIES.length];
        for (int i = 0; i < this.CATEGORIES.length; ++i) {
            final int lCode = i;
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    ArrayList<Analysis> analyses;
                    ArrayList<Transaction> filteredTransactions;
                    AbstractAnalysis analysis = FactoryAnalysis.create(AnalysisServiceImpl.this.context, AnalysisServiceImpl.this.CATEGORIES[lCode]);
                    analysis.performLoadContents();
                    if (!analysis.contents.isEmpty() && !(filteredTransactions = analysis.performFilter(transactions)).isEmpty() && (analyses = analysis.performAnalysis(filteredTransactions)) != null) {
                        AnalysisServiceImpl.this.results.addAll(analyses);
                    }
                }
            });
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.results;
    }
}

