package com.tenqube.visual_third.analysis;

import android.content.Context;

import com.tenqube.visual_third.entity.Contents;
import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;
import com.tenqube.visual_third.repository.AnalysisRepository;

import java.util.ArrayList;

public abstract class AbstractAnalysis {

    private final Context context;

    Lv0 mLv0;

    protected ArrayList<Contents> contents = new ArrayList<>();

    protected AnalysisRepository repository;

    AbstractAnalysis(Context context) {

        this.context = context;
        this.repository = AnalysisRepository.getInstance(context);
    }

    public void performLoadContents() {
        if(mLv0 != null) {
            mLv0.loadContents();
        }
    }

    public ArrayList<Transaction> performFilter(ArrayList<Transaction> transactions) {
        if(mLv0 != null) {
            return mLv0.filterTransactions(transactions);
        } else {
            return new ArrayList<>();
        }
    }

    public ArrayList<Analysis> performAnalysis(ArrayList<Transaction> transactions) {
        if(mLv0 != null) {
            return mLv0.loadAnalysis(transactions);
        } else {
            return new ArrayList<>();
        }
    }


}
