/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.util;

import android.text.TextUtils;
import com.tenqube.visual_third.exception.ParameterException;
import java.text.SimpleDateFormat;
import java.util.Locale;

public class Validator {
    private static final SimpleDateFormat fullDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.KOREA);

    public static void isCustId(String custId) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)custId) || custId.length() > 10) {
            throw new ParameterException("Please check custId (length <= 10");
        }
    }

    public static void isDate(String at) throws ParameterException {
        boolean isValid = !TextUtils.isEmpty((CharSequence)at) && at.length() == 19;
        fullDF.setLenient(false);
        try {
            fullDF.parse(at);
        }
        catch (Exception e) {
            isValid = false;
        }
        if (!isValid) {
            throw new ParameterException("Check date :" + at);
        }
    }

    public static void len(String value, int len) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)value) || value.length() != len) {
            throw new ParameterException(value + " is invalid value, (valid len : " + len + ")");
        }
    }

    public static void isStr(String value, int len) throws ParameterException {
        if (TextUtils.isEmpty((CharSequence)value) || value.length() > len) {
            throw new ParameterException(value + " is invalid value");
        }
    }

    public static void gt(int value, int target) throws ParameterException {
        if (value < target) {
            throw new ParameterException("value: " + value + "/" + "target:" + target);
        }
    }

    public static void lt(int value, int target) throws ParameterException {
        if (value > target) {
            throw new ParameterException("value: " + value + "/" + "target:" + target);
        }
    }

    public static void in(String value, String ... rules) throws ParameterException {
        boolean isValid = false;
        if (!TextUtils.isEmpty((CharSequence)value)) {
            for (String rule : rules) {
                if (!value.equals(rule)) continue;
                isValid = true;
                break;
            }
        }
        if (!isValid) {
            throw new ParameterException("value: " + value + " / value in (" + TextUtils.join((CharSequence)",", (Object[])rules) + "");
        }
    }

    public static void in(int value, Integer ... rules) throws ParameterException {
        boolean isValid = false;
        for (Integer rule : rules) {
            if (value != rule) continue;
            isValid = true;
            break;
        }
        if (!isValid) {
            throw new ParameterException("value: " + value + "/ value in (" + TextUtils.join((CharSequence)",", (Object[])rules) + "");
        }
    }

    public static void notZero(int value) throws ParameterException {
        if (value == 0) {
            throw new ParameterException("value: " + value + " value is zero");
        }
    }

    public static void notNull(Object object) throws ParameterException {
        if (object == null) {
            throw new ParameterException("value is null");
        }
    }
}

