package com.tenqube.visual_third.analysis;

import android.content.Context;

import com.tenqube.visual_third.analysis.category.Alcohol;
import com.tenqube.visual_third.analysis.category.Beauty;
import com.tenqube.visual_third.analysis.category.Cafe;
import com.tenqube.visual_third.analysis.category.Culture;
import com.tenqube.visual_third.analysis.category.Education;
import com.tenqube.visual_third.analysis.category.FamilyEvent;
import com.tenqube.visual_third.analysis.category.Finance;
import com.tenqube.visual_third.analysis.category.Food;
import com.tenqube.visual_third.analysis.category.HealthCare;
import com.tenqube.visual_third.analysis.category.Leports;
import com.tenqube.visual_third.analysis.category.Livings;
import com.tenqube.visual_third.analysis.category.Mart;
import com.tenqube.visual_third.analysis.category.Online;
import com.tenqube.visual_third.analysis.category.Shopping;
import com.tenqube.visual_third.analysis.category.Transport;
import com.tenqube.visual_third.analysis.category.Travel;
import com.tenqube.visual_third.analysis.category.Uncate;
import com.tenqube.visual_third.analysis.category.Withdraw;
import com.tenqube.visual_third.analysis.category.WithdrawMoving;

public class FactoryAnalysis {

    public static AbstractAnalysis create(Context context, int categoryCode) {

        switch (categoryCode) {
            case Monthly.CODE:
                return new Monthly(context);
            case Weekly.CODE:
                return new Weekly(context);
            case Alcohol.CODE:
                return new Alcohol(context);
            case Beauty.CODE:
                return new Beauty(context);
            case Cafe.CODE:
                return new Cafe(context);
            case Culture.CODE:
                return new Culture(context);
            case Education.CODE:
                return new Education(context);
            case FamilyEvent.CODE:
                return new FamilyEvent(context);
            case Finance.CODE:
                return new Finance(context);
            case Food.CODE:
                return new Food(context);
            case HealthCare.CODE:
                return new HealthCare(context);
            case Leports.CODE:
                return new Leports(context);
            case Livings.CODE:
                return new Livings(context);
            case Mart.CODE:
                return new Mart(context);
            case Online.CODE:
                return new Online(context);
            case Shopping.CODE:
                return new Shopping(context);
            case Transport.CODE:
                return new Transport(context);
            case Travel.CODE:
                return new Travel(context);
            case Uncate.CODE:
                return new Uncate(context);
            case Withdraw.CODE:
                return new Withdraw(context);
            default:
                return new WithdrawMoving(context);

        }
    }


}
