package com.tenqube.visual_third.analysis;

import android.content.Context;

import com.tenqube.visual_third.model.analysis.Analysis;
import com.tenqube.visual_third.model.analysis.Transaction;

import java.util.ArrayList;

public abstract class AbstractAnalysis {

    private final Context context;

    protected Lv0 mLv0;

    protected AbstractAnalysis(Context context) {
        this.context = context;
    }

    public ArrayList<Analysis> performAnalysis(ArrayList<Transaction> transactions){
        if(mLv0!=null){
            return mLv0.loadAnalysis(transactions);
        }else{
            return new ArrayList<>();
        }
    }



}
