/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import android.webkit.WebView;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.VisualServiceImpl;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.exception.AuthException;
import com.tenqube.visual_third.manager.PrefManager;
import com.tenqube.visual_third.model.api.SearchCompanyRequest;
import com.tenqube.visual_third.parser.loader.BulkLoader;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.BottomDialog;
import com.tenqube.visual_third.ui.ProgressDialogFragment;
import com.tenqube.visual_third.ui.WebAppInterface;
import com.tenqube.visual_third.util.Utils;
import org.json.JSONException;
import org.json.JSONObject;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class VisualWebActivity
extends AppCompatActivity {
    public static final String ARG_PATH = "ARG_PATH";
    public static final String ARG_POPUP = "ARG_POPUP";
    public static final String TAG = VisualServiceImpl.class.getSimpleName();
    public static final int NOTIFICATION_REQUEST_CODE = 10;
    public static final int INTERNAL_REQUEST_CODE = 11;
    public static final int FINISH = 0;
    public static final int PROGRESS = 1;
    public static final int SHOW_PROGRESS_BAR = 2;
    public static final int ERROR = 3;
    private ProgressDialogFragment progressDialog;
    private PrefManager prefManager;
    private VisualApi api;
    private VisualRepository repository;
    private String path;
    private boolean isPopup;
    private WebView webview;
    private BulkLoader bulkLoader;
    private WebAppInterface webAppInterface;
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Bundle bundle;
                    if (VisualWebActivity.this.progressDialog == null || !VisualWebActivity.this.progressDialog.isAdded() || (bundle = msg.getData()) == null) break;
                    VisualWebActivity.this.progressDialog.setProgressValue(bundle.getInt("now"), bundle.getInt("total"), bundle.getInt("percent"));
                    break;
                }
                case 2: {
                    try {
                        if (VisualWebActivity.this.progressDialog == null) {
                            VisualWebActivity.this.progressDialog = ProgressDialogFragment.newInstance((Context)VisualWebActivity.this);
                            VisualWebActivity.this.progressDialog.setCancelable(false);
                        }
                        if (VisualWebActivity.this.progressDialog.isAdded()) break;
                        FragmentManager fragmentManager = VisualWebActivity.this.getSupportFragmentManager();
                        VisualWebActivity.this.progressDialog.show(fragmentManager, ProgressDialogFragment.TAG);
                    }
                    catch (Exception e) {
                        VisualWebActivity.this.progressDialog = null;
                    }
                    break;
                }
                case 0: {
                    VisualWebActivity.this.prefManager.saveBoolean("TENQUBE_BULK_EXECUTED", true);
                    if (VisualWebActivity.this.progressDialog != null && VisualWebActivity.this.progressDialog.isAdded()) {
                        VisualWebActivity.this.progressDialog.dismiss();
                    }
                    if (VisualWebActivity.this.webview == null) break;
                    VisualWebActivity.this.webview.loadUrl(PrefManager.getInstance(VisualWebActivity.this.getApplicationContext()).loadStringValue("TENQUBE_WEB_URL", "" + VisualWebActivity.this.path));
                    break;
                }
                default: {
                    LogUtil.LOGI((String)TAG, (String)("handler:" + msg.what), (boolean)ParserService.mIsDebug);
                }
            }
            return false;
        }
    });

    public static void startActivity(Context context, String path, boolean isPopup) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance(context).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent(context, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        intent.putExtra(ARG_POPUP, isPopup);
        if (isPopup) {
            intent.addFlags(604012544);
        }
        context.startActivity(intent);
    }

    public static void startActivityForResult(Activity activity, String path) throws AuthException {
        if (TextUtils.isEmpty((CharSequence)PrefManager.getInstance((Context)activity).loadStringValue("TENQUBE_UID", ""))) {
            throw new AuthException("Need to sign up");
        }
        Intent intent = new Intent((Context)activity, VisualWebActivity.class);
        intent.putExtra(ARG_PATH, path);
        activity.startActivityForResult(intent, 11);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            this.api = VisualApi.getInstance(this.getApplicationContext());
            this.repository = VisualRepository.getInstance(this.getApplicationContext());
            this.prefManager = PrefManager.getInstance(this.getApplicationContext());
            this.path = this.getIntent().getStringExtra(ARG_PATH);
            this.isPopup = this.getIntent().getBooleanExtra(ARG_POPUP, false);
            this.setContentView(R.layout.activity_visual_web);
            this.webview = (WebView)this.findViewById(R.id.visual_web_view);
            this.webAppInterface = new WebAppInterface((Activity)this, this.webview, new BottomDialog((Activity)this), VisualRepository.getInstance(this.getApplicationContext()), this.api);
            this.webview.addJavascriptInterface((Object)this.webAppInterface, "visual");
            this.webview.getSettings().setJavaScriptEnabled(true);
            if (this.prefManager.loadStringValue("TENQUBE_QUALIFIER", "dev").equals("dev")) {
                this.webview.getSettings().setCacheMode(2);
            }
            this.syncCategory();
            if (!this.prefManager.isEnabled("TENQUBE_BULK_EXECUTED", false)) {
                LogUtil.LOGI((String)TAG, (String)"\ubc8c\ud06c \ud30c\uc2f1 \uc9c4\ud589", (boolean)ParserService.mIsDebug);
                this.startBulkParsing();
            } else {
                if (this.isPopup) {
                    this.webview.loadUrl(this.prefManager.loadStringValue("TENQUBE_WEB_URL", "") + "/");
                    VisualWebActivity.startActivityForResult((Activity)this, this.path);
                } else {
                    this.webview.loadUrl(this.prefManager.loadStringValue("TENQUBE_WEB_URL", "") + "/" + this.path);
                }
                this.syncSearchFailedTransactions();
            }
        }
        catch (Exception e) {
            this.finish();
        }
    }

    private void syncSearchFailedTransactions() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SearchCompanyRequest request = VisualWebActivity.this.repository.loadFailedSearchTransactions();
                if (request != null) {
                    VisualWebActivity.this.api.searchCompany(request);
                }
                VisualWebActivity.this.api.syncTransactions(null);
            }
        }).start();
    }

    private void syncCategory() {
        this.api.syncCategory(this.prefManager.loadIntValue("TENQUBE_CATEGORY_VERSION", 12));
    }

    private void startBulkParsing() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LogUtil.LOGI((String)TAG, (String)"startBulkParsing start", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader = new BulkLoader((Context)VisualWebActivity.this, VisualWebActivity.this.handler, new BulkLoader.OnSmsLoadFinished(){

                        @Override
                        public void onFinished(boolean isError) {
                            try {
                                if (VisualWebActivity.this.handler != null) {
                                    VisualWebActivity.this.handler.sendEmptyMessage(0);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    LogUtil.LOGI((String)TAG, (String)"2. \ud504\ub85c\uadf8\ub808\uc2a4 \ub2e4\uc774\uc5bc\ub85c\uadf8 show", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.handler.sendEmptyMessage(2);
                    LogUtil.LOGI((String)TAG, (String)"3. \uc9c0\ub09c 6\uac1c\uc6d4 \ubb38\uc790 \ud30c\uc2f1 \uc2dc\uc791", (boolean)ParserService.mIsDebug);
                    VisualWebActivity.this.bulkLoader.doParsing();
                }
                catch (Exception e) {
                    VisualWebActivity.this.handler.sendEmptyMessage(3);
                }
            }
        }).start();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 10: {
                boolean isEnabled = Utils.isNotiEnabled(this.getApplicationContext());
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("isNotiEnabled", isEnabled);
                    String json = jsonObject.toString();
                    if (this.webAppInterface == null) break;
                    this.webAppInterface.onNotiCallback(json);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 11: {
                if (resultCode != -1) break;
                String path = data.getStringExtra("path");
                this.webview.loadUrl(this.prefManager.loadStringValue("TENQUBE_WEB_URL", "") + "/" + path);
            }
        }
    }

    public void onBackPressed() {
        try {
            if (this.webAppInterface != null) {
                this.webAppInterface.onFinish();
            } else {
                super.onBackPressed();
            }
        }
        catch (Exception e) {
            super.onBackPressed();
        }
    }

    public void onResume() {
        super.onResume();
        if (!TextUtils.isEmpty((CharSequence)this.path)) {
            this.overridePendingTransition(R.anim.slide_up, R.anim.stay);
        } else {
            this.overridePendingTransition(0, 0);
        }
    }

    public void onPause() {
        super.onPause();
        this.overridePendingTransition(0, 0);
    }
}

