package com.tenqube.visual_third.model.ui;

import android.text.TextUtils;

import com.tenqube.visual_third.model.api.SearchCompanyResponse;

import java.io.Serializable;

import tenqube.parser.model.Transaction;

import static com.tenqube.visual_third.util.Utils.threeComma;

public class TransactionPopupInfo implements Serializable{

    private Transaction transaction;
    private SearchCompanyResponse.TranCompany tranCompany;


    public TransactionPopupInfo(Transaction transaction, SearchCompanyResponse.TranCompany tranCompany) {
        this.transaction = transaction;
        this.tranCompany = tranCompany;
    }

    public Transaction getTransaction() {
        return transaction;
    }

    public int getLargeCode() {

        try {
            if(tranCompany != null) {
                return Integer.parseInt(tranCompany.getCategory().getLargeCode());
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        return 0;

    }

    public String getCategoryCode() {
        if(tranCompany != null) {
            return tranCompany.getCategory().getCode();
        } else {
            if((transaction.categoryCode + "").length() == 2)
                return transaction.categoryCode + "1010";
        }

        return "" + transaction.categoryCode;
    }


    public String getCompanyTitle() {
        return tranCompany == null ? "" : tranCompany.isPopUpCompanyName() ? tranCompany.getCompany().getName() : transaction.keyword;
    }

    public String getCompanyAddress() {
        return tranCompany == null ? "" : tranCompany.isPopUpCompanyName() ? tranCompany.getCompany().getAddress() : "";
    }

    public String getSpentDate() {
        return transaction == null ? "" : transaction.spentDate;
    }


    public String getPayment() {
        if(transaction == null) return "";

        String payment = transaction.cardName;
        if(!TextUtils.isEmpty(transaction.cardNum)) {
            payment += " " + transaction.cardNum;
        }
        return payment;
    }


    public int getInstallmentCnt() {
        return transaction == null ? 1 :transaction.installmentCount;
    }

    public String getInstallmentStr() {
        int instCnt = getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "일시불" : instCnt + "개월";
    }

    public double getSpentMoney() {
        if(transaction == null) return 0;

        return transaction.spentMoney;
    }


    public String getSpentMoneyStr() {
        return threeComma(getSpentMoney());
    }

}
