/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.db.dao;

import android.database.Cursor;
import com.tenqube.visual_third.db.Db;
import com.tenqube.visual_third.db.QueryGenerator;
import com.tenqube.visual_third.db.ReaderContract;
import com.tenqube.visual_third.entity.UserCategory;
import java.util.ArrayList;
import tenqube.parser.core.ParserService;
import tenqube.parser.util.LogUtil;

public class UserCategoryDao {
    private final Db db;

    public UserCategoryDao(Db db) {
        this.db = db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() {
        LogUtil.LOGI((String)"LOADALL", (String)"UserCategoryDao loadAll", (boolean)ParserService.mIsDebug);
        String query = QueryGenerator.userCategory();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    LogUtil.LOGI((String)"LOADALL", (String)ReaderContract.UserCategoryTable.populateModel(c).toString(), (boolean)ParserService.mIsDebug);
                    c.moveToNext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<UserCategory> loadUserCategories() {
        String query = QueryGenerator.userCategory();
        ArrayList<UserCategory> results = new ArrayList<UserCategory>();
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst()) {
                while (!c.isAfterLast()) {
                    results.add(ReaderContract.UserCategoryTable.populateModel(c));
                    c.moveToNext();
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserCategory loadUserCategory(String repCode) {
        String query = QueryGenerator.userCategory(repCode);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                UserCategory userCategory = ReaderContract.UserCategoryTable.populateModel(c);
                return userCategory;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCategoryId(String repCode) {
        String query = QueryGenerator.userCategory(repCode);
        try (Cursor c = null;){
            c = this.db.runQuery(query);
            if (c != null && c.moveToFirst() && !c.isAfterLast()) {
                int n = c.getInt(c.getColumnIndex("ucId"));
                return n;
            }
        }
        return -1;
    }
}

