/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.util;

import android.content.Context;
import android.support.v4.app.NotificationManagerCompat;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.manager.PrefManager;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import tenqube.parser.core.ParserService;
import tenqube.parser.model.Transaction;
import tenqube.parser.util.LogUtil;

public class Utils {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("00");
    private static final DecimalFormat THREE_COMMA_FORMAT = new DecimalFormat("###,###");

    public static <T> T fromJson(String param, Class<T> classOfT) {
        Gson gson = new Gson();
        return (T)gson.fromJson(param, classOfT);
    }

    public static String toJson(Object object) {
        Gson gson = new Gson();
        return gson.toJson(object);
    }

    public static boolean shouldParsing(String msg) {
        int cnt = 0;
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return false;
        }
        if (msg.contains("\uc6d0")) {
            ++cnt;
        }
        if (msg.contains(".")) {
            ++cnt;
        }
        if (msg.contains(",")) {
            ++cnt;
        }
        if (cnt == 3) {
            return true;
        }
        if (msg.contains("/")) {
            ++cnt;
        }
        return cnt > 2;
    }

    public static String getConvertedDate(long date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date);
        return Utils.getStringDateAsYYYYMMddHHmmss(cal);
    }

    public static String getStringDateAsYYYYMMddHHmmss(Calendar cal) {
        try {
            if (cal == null) {
                cal = Calendar.getInstance();
            }
            return cal.get(1) + "-" + DECIMAL_FORMAT.format(cal.get(2) + 1) + "-" + DECIMAL_FORMAT.format(cal.get(5)) + " " + DECIMAL_FORMAT.format(cal.get(11)) + ":" + DECIMAL_FORMAT.format(cal.get(12)) + ":" + DECIMAL_FORMAT.format(cal.get(13));
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String threeComma(double value) {
        return THREE_COMMA_FORMAT.format((long)value) + "\uc6d0";
    }

    public static String makeDialogPath(int tranId, String keyword, String lCategory, String mCategory, String lCode, String mCode, String spentDate, double amount, int installmentCnt, int cardId, String memo, String dwType, String prevPage) {
        return String.format(Locale.KOREA, "dialog/?id=%1$d&keyword=%2$s&lCategory=%3$s&mCategory=%4$s&lCode=%5$s&mCode=%6$s&date=%7$s&amount=%8$f&installmentCnt=%9$d&cardId=%10$d&memo=%11$s&dwType=%12$s&prevPage=%13$s", tranId, keyword, lCategory, mCategory, lCode, mCode, spentDate, amount, installmentCnt, cardId, memo, dwType, prevPage);
    }

    public static String[] getDateRange(int year, int month, int before) {
        String[] dates = new String[2];
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.add(2, before);
        dates[0] = "'" + calendar.get(1) + "-" + DECIMAL_FORMAT.format(calendar.get(2) + 1) + "-01 00:00:00'";
        calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.add(2, 1);
        dates[1] = "'" + calendar.get(1) + "-" + DECIMAL_FORMAT.format(calendar.get(2) + 1) + "-01 00:00:00'";
        return dates;
    }

    public static int getCategoryIcon(int categoryCode) {
        switch (categoryCode) {
            case 10: {
                return R.drawable.ic_withdraw_etc;
            }
            case 22: {
                return R.drawable.ic_withdraw_food;
            }
            case 24: {
                return R.drawable.ic_withdraw_cafe;
            }
            case 26: {
                return R.drawable.ic_withdraw_alcohol;
            }
            case 32: {
                return R.drawable.ic_withdraw_mart;
            }
            case 34: {
                return R.drawable.ic_withdraw_online;
            }
            case 36: {
                return R.drawable.ic_withdraw_shopping;
            }
            case 42: {
                return R.drawable.ic_withdraw_finance;
            }
            case 44: {
                return R.drawable.ic_withdraw_health_care;
            }
            case 46: {
                return R.drawable.ic_withdraw_beauty;
            }
            case 52: {
                return R.drawable.ic_withdraw_livings;
            }
            case 54: {
                return R.drawable.ic_withdraw_education;
            }
            case 56: {
                return R.drawable.ic_withdraw_culture;
            }
            case 62: {
                return R.drawable.ic_withdraw_transport;
            }
            case 64: {
                return R.drawable.ic_withdraw_leports;
            }
            case 66: {
                return R.drawable.ic_withdraw_travel;
            }
            case 82: {
                return R.drawable.ic_withdraw_family_event;
            }
            case 84: {
                return R.drawable.ic_withdraw;
            }
            case 88: {
                return R.drawable.ic_withdraw_moving_asset;
            }
            case 90: {
                return R.drawable.ic_deposit_etc;
            }
            case 92: {
                return R.drawable.ic_deposit_income_main;
            }
            case 94: {
                return R.drawable.ic_deposit_income_sub;
            }
            case 96: {
                return R.drawable.ic_deposit_loan;
            }
            case 98: {
                return R.drawable.ic_deposit_moving_asset;
            }
        }
        return 0;
    }

    public static void print(String title, ArrayList<Transaction> list) {
        for (Transaction object : list) {
            LogUtil.LOGI((String)"PRINT", (String)("title:" + title + "\n" + "object: " + object.toString()), (boolean)ParserService.mIsDebug);
        }
    }

    public static boolean isNotiEnabled(Context context) {
        return NotificationManagerCompat.getEnabledListenerPackages((Context)context).contains(context.getPackageName()) || PrefManager.getInstance(context).isEnabled("TENQUBE_ACCESS_NOTI_LISTENER", false);
    }
}

