package com.tenqube.visual_third.sms.presentation

import android.content.Context
import com.tenqube.visual_third.manager.PrefManager
import com.tenqube.visual_third.sms.Injection
import com.tenqube.visual_third.sms.data.api.RuleService
import com.tenqube.visual_third.sms.data.api.RuleServiceImpl

class SmsServiceBuilder {

    private var context: Context? = null
    private var ruleService: RuleService? = null

    fun with(context: Context): SmsServiceBuilder = apply {
        this.context = context
    }

    fun build(): SmsService {
        requireNotNull(context) {
            throw Exception("context is null")
        }

        val prefManager = PrefManager.getInstance(context)
        val okHttpClient = Injection.provideOkHttpClient(prefManager)
        val retrofit = Injection.provideRetrofit(okHttpClient)
        val notiParserApi = Injection.provideNotiParserApi(retrofit)
        ruleService = RuleServiceImpl(notiParserApi, prefManager)

        val db = Injection.provideDb(context!!)
        val smsDao = Injection.provideSmsDao(db)
        val smsRuleDao = Injection.provideSmsRuleDao(db)

        val smsRepository = Injection.provideSmsRepository(smsDao)
        val smsRuleRepository = Injection.provideSmsRuleRepository(context!!, smsRuleDao, ruleService!!, prefManager)

        val parseSMSByRuleUseCase = Injection.provideParseSMSByRuleUseCase(smsRuleRepository, smsRepository)
        val deleteAllSmsUseCase = Injection.provideDeleteAllSmsUseCase(smsRepository)

        return SmsServiceImpl(
                parseSMSByRuleUseCase,
                deleteAllSmsUseCase
        )
    }

}