package com.tenqube.visual_third.sms.domain.sms

import com.tenqube.visual_third.sms.domain.utils.SecurityUtil
import java.util.*

data class Sms(var id: String = UUID.randomUUID().toString(),
               val title: String,
               var sender: String,
               val date: Long,
               var msg: String): SmsService {

    override fun toMsg(ori: String): String {
        return ori.replace("\n", "")
    }

    override fun toSender(ori: String): String {
        return ori.replace("-", "")
                .replace("+", "")
    }

    init {
        id = SecurityUtil.sha256(title + sender + msg + date)
        msg = toMsg(msg)
        sender = toSender(sender)
    }

}