package com.tenqube.visual_third.sms.data.source.sms

import android.util.Log
import com.tenqube.visual_third.sms.data.api.NotiParserApi
import com.tenqube.visual_third.sms.data.db.dao.SmsDao
import com.tenqube.visual_third.sms.data.db.model.SmsModel
import com.tenqube.visual_third.sms.domain.sms.Sms
import com.tenqube.visual_third.sms.domain.sms.SmsRepository
import com.tenqube.visual_third.sms.domain.utils.Result
import kotlinx.coroutines.CoroutineDispatcher
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext
import java.lang.Exception

class SmsRepositoryImpl(val smsDao: SmsDao,
                        val ioDispatcher: CoroutineDispatcher = Dispatchers.IO) : SmsRepository {

    override suspend fun isExist(sms: Sms): Result<Boolean> = withContext(ioDispatcher){
        return@withContext try {
            Log.i("parsing", "sms isExist")

            val result = smsDao.isExist(sms.id) != null
            Log.i("parsing", "sms isExist" + result)

            Result.Success(result)
        } catch (e: Exception) {
            Log.i("parsing", "sms isExist" + e)

            Result.Error(e)
        }
    }

    override suspend fun save(sms: Sms): Result<Unit> = withContext(ioDispatcher) {
        return@withContext try {
            smsDao.save(SmsModel(sms.id, System.currentTimeMillis()))
            Result.Success(Unit)
        } catch (e: Exception) {
            Result.Error(e)
        }
    }

    override suspend fun deleteByDate(date: Long): Result<Unit> = withContext(ioDispatcher) {
        return@withContext try {
            smsDao.deleteByDate(date)
            Result.Success(Unit)
        } catch (e: Exception) {
            Result.Error(e)
        }
    }

    override suspend fun deleteAll(): Result<Unit> = withContext(ioDispatcher) {
        return@withContext try {
            smsDao.deleteAll()
            Result.Success(Unit)
        } catch (e: Exception) {
            Result.Error(e)
        }
    }

}