package com.tenqube.visual_third.sms.data.db.model

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.Index
import androidx.room.PrimaryKey
import com.google.gson.JsonObject
import com.tenqube.visual_third.sms.domain.smsrule.SmsRule
import java.util.*

@Entity(tableName = "smsRules",
        indices = [Index(value = ["reg"], unique = true)])
data class SmsRuleModel(

    @PrimaryKey(autoGenerate = true)
    @ColumnInfo(name = "_id")
    val _id: Long,


    @ColumnInfo(name = "id")
    val id: String,

    @ColumnInfo(name = "sender", index = true)
    val sender: String,

    @ColumnInfo(name = "title")
    val title: String,

    @ColumnInfo(name = "reg")
    val reg: String,

    @ColumnInfo(name = "body")
    val body: JsonObject,

    @ColumnInfo(name = "createdAt", defaultValue = "CURRENT_TIMESTAMP")
    val createdAt: Long = System.currentTimeMillis()
) {
    fun toEntity(): SmsRule {
        return SmsRule(id,
                sender,
                title,
                reg,
                body)
    }
}
