package com.tenqube.visual_third.sms.data.db

import android.content.Context
import androidx.room.Database
import androidx.room.Room
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import androidx.sqlite.db.SupportSQLiteDatabase
import com.tenqube.visual_third.sms.data.db.converter.Converters
import com.tenqube.visual_third.sms.data.db.dao.SmsDao
import com.tenqube.visual_third.sms.data.db.dao.SmsRuleDao
import com.tenqube.visual_third.sms.data.db.model.SmsModel
import com.tenqube.visual_third.sms.data.db.model.SmsRuleModel

@Database(
        entities = [
            SmsModel::class,
            SmsRuleModel::class
        ],
        version = 1,
        exportSchema = false
)
@TypeConverters(Converters::class)
abstract class SmsDatabase : RoomDatabase() {

    abstract fun smsDao(): SmsDao
    abstract fun smsRuleDao(): SmsRuleDao


    companion object {
        private const val databaseName = "visual_clip_sms.db"

        private var instance: SmsDatabase? = null

        @Synchronized
        fun get(context: Context): SmsDatabase {
            if (instance == null) {
                instance = Room.databaseBuilder(
                        context.applicationContext,
                        SmsDatabase::class.java, databaseName)
                        .addCallback(object : RoomDatabase.Callback() {
                            override fun onCreate(db: SupportSQLiteDatabase) {
                            }
                        })
                        .build()
            }
            return instance!!
        }
    }
}