/*
 * Decompiled with CFR 0.152.
 */
package com.tenqube.visual_third.model.ui;

import com.tenqube.visual_third.entity.JoinedTransaction;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;
import com.tenqube.visual_third.model.js.Receipt;
import com.tenqube.visual_third.util.Utils;
import java.io.Serializable;

public class TransactionPopupInfo
implements Serializable {
    private final JoinedTransaction transaction;
    private final SearchCompanyResponse.TranCompany tranCompany;

    public TransactionPopupInfo(JoinedTransaction transaction, SearchCompanyResponse.TranCompany tranCompany) {
        this.transaction = transaction;
        this.tranCompany = tranCompany;
    }

    public JoinedTransaction getTransaction() {
        return this.transaction;
    }

    public SearchCompanyResponse.TranCompany getTranCompany() {
        return this.tranCompany;
    }

    public String getCategoryCode() {
        if (this.tranCompany != null) {
            return this.tranCompany.getCategory().getCode();
        }
        return this.transaction.getCategory().getCode() + "";
    }

    public String getCompanyTitle() {
        return this.tranCompany == null ? "" : (this.tranCompany.isPopUpCompanyName() ? this.tranCompany.getCompany().getName() : this.transaction.getTransaction().getKeyword());
    }

    public String getCompanyAddress() {
        return this.tranCompany == null ? "" : (this.tranCompany.isPopUpCompanyName() ? this.tranCompany.getCompany().getAddress() : "");
    }

    public String getSpentDate() {
        return this.transaction == null ? "" : this.transaction.getTransaction().getSpentDate();
    }

    public String getPayment() {
        if (this.transaction == null) {
            return "";
        }
        String payment = this.transaction.getCard().getChangeName();
        return payment;
    }

    public int getInstallmentCnt() {
        return this.transaction == null ? 1 : this.transaction.getTransaction().getInstallmentCnt();
    }

    public String getInstallmentStr() {
        int instCnt = this.getInstallmentCnt();
        return instCnt == 1 || instCnt == 0 ? "\uc77c\uc2dc\ubd88" : instCnt + "\uac1c\uc6d4";
    }

    public double getSpentMoney() {
        if (this.transaction == null) {
            return 0.0;
        }
        return this.transaction.getTransaction().getSpentMoney();
    }

    public String getSpentMoneyStr() {
        return Utils.threeComma(this.getSpentMoney());
    }

    public Receipt toReceipt() {
        return new Receipt(this.getTransaction().getTransaction().getId(), this.getCompanyTitle(), this.getCompanyAddress(), this.getTransaction().getTransaction().getKeyword(), this.getTransaction().getTransaction().getInstallmentCnt(), this.getTransaction().getTransaction().getDwType(), this.getTransaction().getTransaction().getSpentMoney(), this.getTransaction().getTransaction().getSpentDate(), this.getTransaction().getTransaction().getCurrency(), this.getTransaction().getCategory().getLarge(), this.getTransaction().getCategory().getMedium(), this.getTransaction().getCategory().getSmall(), this.getTranCompany().getCompany().getName(), this.getTranCompany().getCompany().getAddress(), this.getTranCompany().isPopUpCompanyName(), this.getTransaction().getCard().getChangeName(), this.getTransaction().getCard().getChangeType(), this.getTransaction().getCard().getChangeSubType());
    }
}

