package com.tenqube.visual_third.util;

import android.text.TextUtils;

import com.tenqube.visual_third.exception.ParameterException;

import static com.tenqube.visual_third.util.Utils.fullDF;
import static com.tenqube.visual_third.util.Utils.timeDf;
import static com.tenqube.visual_third.util.Utils.ymdDF;

public class Validator {


    public static void isDate(String at) throws ParameterException {

        boolean isValid = !TextUtils.isEmpty(at) && at.length() == 19;
        fullDF.setLenient(false);
        try {
            fullDF.parse(at);
        } catch (Exception e) {
            isValid = false;
        }
        if(!isValid) throw new ParameterException("Check date :" + at + "at.length" + at.length());

    }

    public static void isTime(String at) throws ParameterException {

        boolean isValid = !TextUtils.isEmpty(at) && at.length() == 8;
        timeDf.setLenient(false);
        try {
            timeDf.parse(at);
        } catch (Exception e) {
            isValid = false;
        }
        if(!isValid) throw new ParameterException("Check date :" + at);

    }

     public static void isYMD(String at) throws ParameterException {

        boolean isValid = !TextUtils.isEmpty(at) && at.length() == 10;
        ymdDF.setLenient(false);
        try {
            ymdDF.parse(at);
        } catch (Exception e) {
            isValid = false;
        }
        if(!isValid) throw new ParameterException("Check date :" + at);

    }

    public static void len(String value, int len) throws ParameterException {
        if(TextUtils.isEmpty(value) || value.length() != len) throw new ParameterException(value + " is invalid value, (valid len : " + len + ")");
    }

    public static void isStr(String value, int len) throws ParameterException {
        if(TextUtils.isEmpty(value) || value.length() > len) throw new ParameterException(value + " is invalid value");
    }

    public static void isStrWithNull(String value, int len) throws ParameterException {
        if(value == null || value.length() > len) throw new ParameterException(value + " is invalid value");
    }

    public static void gt(int value, int target) throws ParameterException {
        if(value < target) throw new ParameterException("value: " + value + "/" + "target:" + target);
    }

    public static void lt(int value, int target) throws ParameterException {
        if(value > target) throw new ParameterException("value: " + value + "/" + "target:" + target);
    }

    public static void in(String value, String... rules) throws  ParameterException {

        boolean isValid = false;
        if(!TextUtils.isEmpty(value)) {
            for(String rule : rules) {

                if(value.equals(rule)) {
                    isValid = true;
                    break;
                }
            }
        }

        if(!isValid) throw new ParameterException("value: " + value + " / value in (" + TextUtils.join(",", rules) + "");
    }

    public static void in(int value, Integer... rules) throws  ParameterException {
        boolean isValid = false;
        for(Integer rule : rules) {

            if(value == rule) {
                isValid = true;
                break;
            }
        }

        if(!isValid) throw new ParameterException("value: " + value + "/ value in (" + TextUtils.join(",", rules) + "");
    }

    public static void notZero(int value) throws ParameterException {
        if(value == 0) throw new ParameterException("value: " + value + " value is zero");
    }

    public static void notNull(Object object) throws ParameterException {
        if(object == null) throw new ParameterException("value is null");
    }

    public static void notEmpty(Integer[] values) throws ParameterException {
        if(values == null || values.length == 0) throw new ParameterException("values is empty");
    }
}
