package com.tenqube.visual_third.manager;

import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.bumptech.glide.Glide;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.MobileAds;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.ads.formats.UnifiedNativeAdView;
import com.tenqube.visual_third.OnAdLoadedListener;
import com.tenqube.visual_third.R;
import com.tenqube.visual_third.api.VisualApi;
import com.tenqube.visual_third.entity.Advertisement;
import com.tenqube.visual_third.model.api.AdInfoResponse;
import com.tenqube.visual_third.model.api.AdResponse;
import com.tenqube.visual_third.repository.VisualRepository;
import com.tenqube.visual_third.ui.VisualWebActivity;
import com.tenqube.visual_third.util.GoOpenMarketUtil;
import com.tenqube.visual_third.util.Utils;

import java.util.ArrayList;

import static com.tenqube.visual_third.api.VisualApi.API_KEY;

public class AdManager {

    public static final String TAG = AdManager.class.getSimpleName();

    public static final String AD_ID = "ca-app-pub-1003660361092577~4657260383";
    public static final String UNIT_ID = "ca-app-pub-1003660361092577/2414077097";

//    public static final String TEST_UNIT_ID = "ca-app-pub-3940256099942544/2247696110";
    private static AdManager mInstance = null;
    private VisualRepository repository;
    private VisualApi callApi;
    private Context mContext;
    private View defaultView;
    private View adContainer;
    private FrameLayout mAdView;
//    private MobonManager mobonManager;

    private View resultAdView;

    public static AdManager getInstance(Context ctx) {

        synchronized (AdManager.class) {
            if (mInstance == null) {
                mInstance = new AdManager(ctx.getApplicationContext());
            }
        }
        return mInstance;
    }

    public View getAdView() {

        try {
//            if(mobonManager != null) {
//                mobonManager.onImpression();
//            }
            return resultAdView;
        }catch (Exception e) {
            return null;
        }

    }

    private AdManager(Context context) {
        this.mContext = context;

        this.callApi = VisualApi.getInstance(context);
        this.repository = VisualRepository.getInstance(context);

//        mobonManager = new MobonManager(context);

        try {
            MobileAds.initialize(context, AdManager.AD_ID);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 1. Visual Api 호출
     * 2. 만족하는 광고 체크
     * 3. 없는경우 구글 admob 호출
     * 4. 로드 실패한경우 디폴트 광고 호출
     * @param listener
     */
    public void loadAd(@NonNull OnAdLoadedListener listener) {
        loadVisualAd(listener);
    }

    /**
     * 1. 버전 체크
     * 2. 버전 다른 경우 동기화 요청
     * 3. 동기화
     * 4. 광고 로드
     * 5. 조건에 만족하는지 체크
     * 6. 만족하는 광고
     * @param listener
     */
    private void loadVisualAd(final OnAdLoadedListener listener) {

        try {
            String[] authInfos = callApi.getAuthInfo();

            AdInfoResponse versionResponse = callApi.getAdInfo(authInfos[API_KEY]);

            if(versionResponse != null && !versionResponse.shouldShowAd()) {
                resultAdView = null;
                listener.onAdLoaded(null);
                return;
            }

            // version
            int version = repository.loadAdVersion();
            if(versionResponse != null && versionResponse.getVersion() > version) {
                AdResponse adResponse = callApi.getAds(versionResponse.getVersion(), authInfos[API_KEY]);
                if(adResponse != null) {
                    defaultView = null;
                    repository.mergeAdvertisement(adResponse, versionResponse.getVersion());
                }
            }
            // loadAd
            ArrayList<Advertisement> ads = repository.loadAds();

            // isSatisfied
            final ArrayList<Advertisement> satisfiedAds = new ArrayList<>();

            boolean isSatisfied;
            int priority = -1;
            for(Advertisement ad : ads) {

                if(priority != -1 && priority != ad.getPriority())
                    break;

                isSatisfied = repository.isSatisfied(ad.getQuery());

                if(isSatisfied) {
                    satisfiedAds.add(ad);
                }

                priority = ad.getPriority();
            }

            new Handler(mContext.getMainLooper()).post(new Runnable() {
                public void run() {
                    // main thread 처리
                    if(!satisfiedAds.isEmpty()) {
                        // priority
                        Advertisement advertisement = satisfiedAds.get(Utils.getRandomNumber(satisfiedAds.size()));
                        populateView(advertisement);
                        resultAdView = adContainer;
                        listener.onAdLoaded(adContainer);

                    } else {

                        if(mAdView == null) {
                            loadThirdPartyAd(listener);
                        } else {
                            resultAdView = mAdView;
                            listener.onAdLoaded(mAdView);
                        }
//                        loadThirdPartyAd(null);
                    }
                }
            });

        } catch (Exception e) {
            loadThirdPartyAd(listener);
        }
    }

    private void populateView(@NonNull final Advertisement advertisement) {

        adContainer = LayoutInflater.from(mContext).inflate(R.layout.ad_view, null, false);
        setBgColor(adContainer, advertisement.getColors().getBgColor());

        ImageView imageTextView = adContainer.findViewById(R.id.image);

        RelativeLayout adTextContainer = adContainer.findViewById(R.id.ad_text_container);

        adContainer.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                goIntent(advertisement);
            }
        });

        if(!TextUtils.isEmpty(advertisement.getImage())) {

            imageTextView.setVisibility(View.VISIBLE);
            Glide.with(mContext).load(advertisement.getImage()).into(imageTextView);
            adTextContainer.setVisibility(View.GONE);

        } else {
            imageTextView.setVisibility(View.GONE);
            adTextContainer.setVisibility(View.VISIBLE);

            ImageView iconImageView = adContainer.findViewById(R.id.icon_image);
            Glide.with(mContext).load(advertisement.getIconImage()).into(iconImageView);

            TextView labelTextView = adContainer.findViewById(R.id.label);
            labelTextView.setText(advertisement.getLabel());
            setTextColor(labelTextView, advertisement.getColors().getLabelColor());

            TextView titleTextView = adContainer.findViewById(R.id.title);
            titleTextView.setText(advertisement.getTitle());
            setTextColor(titleTextView, advertisement.getColors().getTitleColor());

//            TextView contentTextView = adContainer.findViewById(R.id.content);
//            contentTextView.setText(advertisement.getContent());
//            setTextColor(contentTextView, advertisement.getColors().getContentColor());

            TextView linktoTextView = adContainer.findViewById(R.id.linkto);
            linktoTextView.setText(advertisement.getLinkToStr());
            setTextColor(linktoTextView, advertisement.getColors().getLinkToColor());

        }
    }

//    private void populateMobonAdView(MobonManager.AdItem adItem, FrameLayout adView) {
//        ImageView imageView = adView.findViewById(R.id.main_item_img);
//        Glide.with(mContext).load(adItem.imgUrl).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(imageView);
//        ImageView logoImageView = adView.findViewById(R.id.logo);
//        Glide.with(mContext).load(adItem.mobonLogo).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(logoImageView);
//    }
//
//    private void populateMobonNativeAdView(MobonManager.AdItem adItem, FrameLayout adView) {
//
//        String bgColor = repository.getAdmobColor(PrefManager.ADMOB_BG_COLOR, "#eeeeee");
//        String titleColor = repository.getAdmobColor(PrefManager.ADMOB_TITLE_COLOR, "#000000");
////        String contentColor = repository.getAdmobColor(PrefManager.ADMOB_CONTENT_COLOR);
//        String labelColor = repository.getAdmobColor(PrefManager.ADMOB_LABEL_COLOR, "#000000");
//        String linkToColor = repository.getAdmobColor(PrefManager.ADMOB_LINK_COLOR, "#000000");
//
//
//        setBgColor(adView, bgColor);
//
//        TextView labelTextView = adView.findViewById(R.id.label);
//        setTextColor(labelTextView, labelColor);
//
//        TextView headLine = adView.findViewById(R.id.title);
//        ImageView iconView = adView.findViewById(R.id.icon_image);
//
//        // The headline is guaranteed to be in every UnifiedNativeAd.
//        headLine.setText(TextUtils.isEmpty(adItem.title) ? "" : adItem.title);
//        setTextColor(headLine, titleColor);
//
//        TextView priceTextView = adView.findViewById(R.id.price);
//        setTextColor(priceTextView, linkToColor);
//        priceTextView.setText(TextUtils.isEmpty(adItem.price) ? "" : adItem.price);
//
//
//
//        ImageView logoImageView = adView.findViewById(R.id.logo);
//        Glide.with(mContext).load(adItem.mobonLogo).diskCacheStrategy(DiskCacheStrategy.SOURCE).into(logoImageView);
//
//        if (TextUtils.isEmpty(adItem.imgUrl)) {
//            iconView.setVisibility(View.GONE);
//        } else {
//            Glide.with(mContext).load(adItem.imgUrl).centerCrop().diskCacheStrategy(DiskCacheStrategy.SOURCE).into(iconView);
//            iconView.setVisibility(View.VISIBLE);
//        }
//
//    }

    private void populateUnifiedNativeAdView(UnifiedNativeAd nativeAd, UnifiedNativeAdView adView) {

        String bgColor = repository.getAdmobColor(PrefManager.ADMOB_BG_COLOR, "#eeeeee");
        String titleColor = repository.getAdmobColor(PrefManager.ADMOB_TITLE_COLOR, "#000000");
//        String contentColor = repository.getAdmobColor(PrefManager.ADMOB_CONTENT_COLOR);
        String labelColor = repository.getAdmobColor(PrefManager.ADMOB_LABEL_COLOR, "#000000");
        String linkToColor = repository.getAdmobColor(PrefManager.ADMOB_LINK_COLOR, "#000000");

        setBgColor(adView, bgColor);

        TextView labelTextView = adView.findViewById(R.id.label);
        setTextColor(labelTextView, labelColor);

        adView.setHeadlineView(adView.findViewById(R.id.title));
        adView.setIconView(adView.findViewById(R.id.icon_image));
//        adView.setBodyView(adView.findViewById(R.id.content));
        adView.setCallToActionView(adView.findViewById(R.id.linkto));


        // The headline is guaranteed to be in every UnifiedNativeAd.
        ((TextView) adView.getHeadlineView()).setText(nativeAd.getHeadline());
        setTextColor(((TextView) adView.getHeadlineView()), titleColor);
        // These assets aren't guaranteed to be in every UnifiedNativeAd, so it's important to
        // check before trying to display them.
//        if (nativeAd.getBody() == null) {
//            adView.getBodyView().setVisibility(View.INVISIBLE);
//        } else {
//            adView.getBodyView().setVisibility(View.VISIBLE);
//            ((TextView) adView.getBodyView()).setText(nativeAd.getBody());
//            setTextColor(((TextView) adView.getBodyView()), contentColor);
//
//        }

        if (nativeAd.getCallToAction() == null) {
            adView.getCallToActionView().setVisibility(View.INVISIBLE);
        } else {
            adView.getCallToActionView().setVisibility(View.VISIBLE);
            ((TextView) adView.getCallToActionView()).setText(nativeAd.getCallToAction());
            setTextColor(((TextView) adView.getCallToActionView()), linkToColor);
        }



        if (nativeAd.getIcon() == null) {
            adView.getIconView().setVisibility(View.GONE);
        } else {
            ((ImageView) adView.getIconView()).setImageDrawable(
                    nativeAd.getIcon().getDrawable());
            adView.getIconView().setVisibility(View.VISIBLE);
        }

//        if (nativeAd.getPrice() == null) {
//            adView.getPriceView().setVisibility(View.INVISIBLE);
//        } else {
//            adView.getPriceView().setVisibility(View.VISIBLE);
//            ((TextView) adView.getPriceView()).setText(nativeAd.getPrice());
//        }
//
//        if (nativeAd.getStore() == null) {
//            adView.getStoreView().setVisibility(View.INVISIBLE);
//        } else {
//            adView.getStoreView().setVisibility(View.VISIBLE);
//            ((TextView) adView.getStoreView()).setText(nativeAd.getStore());
//        }
//
//        if (nativeAd.getStarRating() == null) {
//            adView.getStarRatingView().setVisibility(View.INVISIBLE);
//        } else {
//            ((RatingBar) adView.getStarRatingView())
//                    .setRating(nativeAd.getStarRating().floatValue());
//            adView.getStarRatingView().setVisibility(View.VISIBLE);
//        }
//
//        if (nativeAd.getAdvertiser() == null) {
//            adView.getAdvertiserView().setVisibility(View.INVISIBLE);
//        } else {
//            ((TextView) adView.getAdvertiserView()).setText(nativeAd.getAdvertiser());
//            adView.getAdvertiserView().setVisibility(View.VISIBLE);
//        }

        // This method tells the Google Mobile Ads SDK that you have finished populating your
        // native ad view with this native ad. The SDK will populate the adView's MediaView
        // with the media content from this native ad.
        adView.setNativeAd(nativeAd);

    }

    private void loadThirdPartyAd(final OnAdLoadedListener listener) {

//        String adType = selectAdType();
//
//        if(AD_TYPE_MOBON.equals(adType)) {
//            loadMobon(listener);
//        } else {
            loadAdmob(listener);
//        }
    }

//    private String selectAdType() {
//
//        try {
//            String ratio = repository.getAdType(); //2:8
//            String[] ratios = ratio.split(":");
//            int mobon = Integer.parseInt(ratios[0]);
//            int admob = Integer.parseInt(ratios[1]);
//
//            List<String> items = new ArrayList<>();
//
//            for(int i = 0 ; i < mobon ; i++) {
//                items.add(AD_TYPE_MOBON);
//            }
//
//            for(int i = 0 ; i < admob ; i++) {
//                items.add(AD_TYPE_ADMOB);
//            }
//            Random rand = new Random();
//            String adType = items.get(rand.nextInt(items.size()));
//            return adType;
//        } catch (Exception e) {
//            return AD_TYPE_ADMOB;
//        }
//
//    }

//    private void loadMobon(final  OnAdLoadedListener listener) {
//
//        mobonManager.loadAd(new Callback<MobonManager.AdItem>() {
//            @Override
//            public void onDataLoaded(final MobonManager.AdItem data) {
//                if(data == null) {
//                    mAdView = null;
//                    if(listener != null) {
//                        resultAdView = defaultView;
//                        listener.onAdLoaded(defaultView);
//                    }
//                } else {
//                    FrameLayout adView = (FrameLayout) LayoutInflater.from(mContext)
//                            .inflate(data.layout, null);
//
//                    adView.setOnClickListener(new View.OnClickListener() {
//                        @Override
//                        public void onClick(View v) {
//
//                            try {
//                                if(mContext != null) {
//                                    Intent i = new Intent(Intent.ACTION_VIEW);
//                                    Uri u = Uri.parse(data.landingUrl);
//                                    i.setData(u);
//                                    mContext.startActivity(i);
//                                }
//                            } catch (Exception e) {
//                                e.printStackTrace();
//                            }
//                        }
//                    });
//
//                    if(data.layout == R.layout.adlist_ad_item) {
//                        populateMobonAdView(data, adView);
//                    } else {
//                        populateMobonNativeAdView(data, adView);
//                    }
//
//                    if(listener != null) {
//                        resultAdView = adView;
//                        listener.onAdLoaded(adView);
//                        mAdView = null;
//                    } else {
//                        mAdView = adView;
//                    }
//                }
//            }
//        });
//    }


    private void loadAdmob(final OnAdLoadedListener listener) {
        AdLoader.Builder builder = new AdLoader.Builder(mContext, UNIT_ID);

        builder.forUnifiedNativeAd(new UnifiedNativeAd.OnUnifiedNativeAdLoadedListener() {
            @Override
            public void onUnifiedNativeAdLoaded(UnifiedNativeAd unifiedNativeAd) {

                UnifiedNativeAdView adView = (UnifiedNativeAdView) LayoutInflater.from(mContext)
                        .inflate(R.layout.admob_view, null);

                populateUnifiedNativeAdView(unifiedNativeAd, adView);

                if(listener != null) {
                    resultAdView = adView;
                    listener.onAdLoaded(adView);
                    mAdView = null;
                } else {
                    mAdView = adView;
                }
            }

        });

        VideoOptions videoOptions = new VideoOptions.Builder()
                .setStartMuted(true)
                .build();

        NativeAdOptions adOptions = new NativeAdOptions.Builder()
                .setVideoOptions(videoOptions)
                .build();

        builder.withNativeAdOptions(adOptions);

        AdLoader adLoader = builder.withAdListener(new AdListener() {

            @Override
            public void onAdFailedToLoad(int errorCode) {

                mAdView = null;
                if(listener != null) {
                    resultAdView = defaultView;
                    listener.onAdLoaded(defaultView);
                }
            }
        }).build();

//        Bundle extras = new FacebookAdapter.FacebookExtrasBundleBuilder()
//                .build();

        AdRequest nativeAdRequest = new AdRequest.Builder()
                .build();
        adLoader.loadAd(nativeAdRequest);
    }

    private void goIntent(Advertisement ad) {

        try {

            if("app".equals(ad.getLinkToType())) {

                VisualWebActivity.startActivity(mContext, "");

            } else if("market".equals(ad.getLinkToType())) {

                GoOpenMarketUtil.openOnGooglePlayMarket(mContext, ad.getLinkTo());

            } else if("web".equals(ad.getLinkToType())) {
                Intent i = new Intent(Intent.ACTION_VIEW);
                i.setData(Uri.parse(ad.getLinkTo()));
                mContext.startActivity(i);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBgColor(View view, String bgColor) {
        try {
            if(!TextUtils.isEmpty(bgColor)) {
                view.setBackgroundResource(R.drawable.round);
                GradientDrawable drawable = (GradientDrawable) view.getBackground();
                drawable.setColor(Color.parseColor(bgColor));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    private void setTextColor(TextView view, String textColor) {
        try {
            if(!TextUtils.isEmpty(textColor)) {
                view.setTextColor(Color.parseColor(textColor));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}

