package com.tenqube.visual_third.model.api;

import com.google.gson.annotations.SerializedName;

import java.io.Serializable;

public class SignUpResponse implements Serializable {

    @SerializedName("results")
    private  Results results;

    public Results getResults() {
        return results;
    }

    public static class Results implements Serializable {

        private Search search;
        private Web web;
        private Authorization authorization;


        public Web getWeb() {
            return web;
        }

        public Search getSearch() {
            return search;
        }

        public Authorization getAuthorization() {
            return authorization;
        }
    }


    public static class Search implements Serializable {
        private String url;
        private String apiKey;

        public String getUrl() {
            return url;
        }

        public String getApiKey() {
            return apiKey;
        }

        @Override
        public String toString() {
            return "Search{" +
                    "url='" + url + '\'' +
                    ", apiKey='" + apiKey + '\'' +
                    '}';
        }
    }

    public static class Web implements Serializable {
        private String url;

        public String getUrl() {
            return url;
        }
    }

    public static class Authorization implements Serializable {

        private String sdk;

        public String getSdk() {
            return sdk;
        }

        @Override
        public String toString() {
            return "Authorization{" +
                    "sdk='" + sdk + '\'' +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "SignUpResponse{" +
                "results=" + results +
                '}';
    }
}
