package com.tenqube.visual_third.model.parser;

import android.text.TextUtils;

import com.tenqube.visual_third.entity.Category;
import com.tenqube.visual_third.entity.ClipCategory;
import com.tenqube.visual_third.exception.ParameterException;
import com.tenqube.visual_third.model.api.SearchCompanyResponse;

import java.io.Serializable;

import tenqube.parser.constants.Constants;

import static com.tenqube.visual_third.util.Utils.getCategoryIcon;
import static com.tenqube.visual_third.util.Utils.threeComma;
import static com.tenqube.visual_third.util.Validator.notNull;

public class TransactionData implements Serializable {

    /**
     * 내역 고유 id
     */
    private int tranId;

    private int cardId;

    private boolean isCredit;

    private String memo;

    private int dwType;

    private int largeIconResId;

    private String lCategory;

    private String mCategory;

    private String sCategory;

    /**
     * 카테고리 코드
     */
    private String categoryCode;

    /**
     * 소비 키워드
     */
    private String keyword;

    /**
     * 소비된 지역 주소
     */
    private String address;

    private String companyTitle;

    /**
     * 거래일시
     */
    private String spentDate;

    /**
     * 결제 수단
     */
    private String payment;

    /**
     * 할부 개월수
     */
    private int installmentCount;

    /**
     * 결제 금액
     */
    private double amount;

    private ClipCategory clipCategory;

    public TransactionData(int tranId,
                           com.tenqube.visual_third.model.parser.Transaction transaction,
                           final SearchCompanyResponse.TranCompany company,
                           Category category,
                           ClipCategory clipCategory) throws ParameterException {

        notNull(transaction);
        notNull(category);
        notNull(clipCategory);

        this.clipCategory = clipCategory;

        this.tranId = tranId;
        this.cardId = transaction.getCardId();
        this.keyword = transaction.getParsedTransaction().keyword;

        this.spentDate = transaction.getParsedTransaction().spentDate;
        this.amount = transaction.getParsedTransaction().spentMoney;
        this.installmentCount = transaction.getParsedTransaction().installmentCount;
        this.memo = transaction.getParsedTransaction().memo;
        this.dwType = transaction.getParsedTransaction().dwType;
        this.lCategory = category.getLarge();
        this.mCategory = category.getMedium();
        this.sCategory = category.getSmall();

        this.categoryCode = category.getCode() + "";

        this.largeIconResId = getCategoryIcon(Integer.parseInt(category.getLargeCode()));

        this.payment = transaction.getParsedTransaction().cardName;
        this.isCredit = transaction.getParsedTransaction().cardType == Constants.CardType.CARD.ordinal();
        if(!TextUtils.isEmpty(transaction.getParsedTransaction().cardNum)) {
            payment += " " + transaction.getParsedTransaction().cardNum;
        }

        this.address = company.isPopUpCompanyName() ? company.getCompany().getAddress() : "";
        this.companyTitle = company.isPopUpCompanyName() ? company.getCompany().getName() : transaction.getParsedTransaction().keyword;
    }

    public ClipCategory getClipCategory() {
        return clipCategory;
    }

    public boolean isCredit() {
        return isCredit;
    }

    public int getTranId() {
        return tranId;
    }

    public int getCardId() {
        return cardId;
    }

    public String getMemo() {
        return memo;
    }

    public int getDwType() {
        return dwType;
    }

    public int getLargeIconResId() {
        return largeIconResId;
    }

    public String getlCategory() {
        return lCategory;
    }

    public String getmCategory() {
        return mCategory;
    }

    public String getsCategory() {
        return sCategory;
    }

    public String getCategoryCode() {
        return categoryCode;
    }

    public String getKeyword() {
        return keyword;
    }

    public String getAddress() {
        return address;
    }

    public String getSpentDate() {
        return spentDate;
    }

    public String getPayment() {
        return payment;
    }

    public int getInstallmentCount() {
        return installmentCount;
    }

    public double getAmount() {
        return amount;
    }

    public String getInstallmentStr() {
        return installmentCount == 1 || installmentCount == 0 ? "일시불" : installmentCount + "개월";
    }

    public String getSpentMoneyStr() {
        return threeComma(amount);
    }

    public String getCompanyTitle() {

        return companyTitle;
    }
}
